var express = require("express");
const PaymentController = require("../controllers/PaymentController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", PaymentController.paymentList,utility.unAuth);

router.get("/me", PaymentController.paymentUserList,utility.unAuth);
router.get("/user/:id", PaymentController.paymentSpecificUserList,utility.unAuth);
router.get("/:id", PaymentController.paymentDetail,utility.unAuth);
router.post("/", PaymentController.paymentStore,utility.unAuth);
router.put("/:id", PaymentController.paymentUpdate,utility.unAuth);
router.delete("/:id", PaymentController.paymentDelete,utility.unAuth);

module.exports = router;