var express = require("express");
const LoanTypeController = require("../controllers/LoanTypeController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", LoanTypeController.loanTypeList,utility.unAuth);
router.get("/:id", LoanTypeController.loanTypeDetail,utility.unAuth);
router.post("/", LoanTypeController.loanTypeStore,utility.unAuth);
router.put("/:id", LoanTypeController.loanTypeUpdate,utility.unAuth);
router.delete("/:id", LoanTypeController.loanTypeDelete,utility.unAuth);
router.post("/bulk-delete", LoanTypeController.loanTypeBulkDelete,utility.unAuth);

module.exports = router;