var express = require("express");
const LoanController = require("../controllers/LoanController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", LoanController.loanList,utility.unAuth);
router.get("/:id", LoanController.loanDetail,utility.unAuth);
router.get("/type/:id", LoanController.loanTypeList,utility.unAuth);
router.post("/", LoanController.loanStore,utility.unAuth);
router.put("/:id", LoanController.loanUpdate,utility.unAuth);
router.delete("/:id", LoanController.loanDelete,utility.unAuth);
router.post("/bulk-delete", LoanController.loanBulkDelete,utility.unAuth);

module.exports = router;