var express = require("express");
const LanguageController = require("../controllers/LanguageController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", LanguageController.langList,utility.unAuth);
router.get("/:id", LanguageController.langDetail,utility.unAuth);
router.post("/", LanguageController.langStore,utility.unAuth);
router.put("/:id", LanguageController.langUpdate,utility.unAuth);
router.delete("/:id", LanguageController.langDelete,utility.unAuth);
router.post("/bulk-delete", LanguageController.langBulkDelete,utility.unAuth);

module.exports = router;