var express = require("express");
const JobTypeController = require("../controllers/JobTypeController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", JobTypeController.jobTypeList,utility.unAuth);
router.get("/:id", JobTypeController.jobTypeDetail,utility.unAuth);
router.post("/", JobTypeController.jobTypeStore,utility.unAuth);
router.put("/:id", JobTypeController.jobTypeUpdate,utility.unAuth);
router.delete("/:id", JobTypeController.jobTypeDelete,utility.unAuth);
router.post("/bulk-delete", JobTypeController.jobTypeBulkDelete,utility.unAuth);

module.exports = router;