var express = require("express");
var authRouter = require("./auth");
var userRouter = require("./user");
var loanRouter = require("./loan");
var loanTypeRouter = require("./loanType");
var userLoanRouter = require("./userLoan");
var residentialTypeRouter = require("./residentialType");
var NotificationRouter = require("./notification");
var languageRouter = require("./language");
var paymentRouter = require("./payment");
var loanBannerRouter = require('./loanBanner');
var offerBannerRouter = require('./offerBanner');
var adminRouter = require('./admin');
var jobTypeRouter = require('./jobType');
var profileRouter = require('./profile');
var loanStatusRouter = require('./loanStatus');
var emiStatusRouter = require('./emiStatus');
var userUserLoanRouter = require('./user/userLoan');
var userCibilRouter = require('./user/cibil');
var userEmiRouter = require("./user/userEmi");
var rateUsRouter = require("./user/rateUs");
var emiCalculatorRouter = require("./user/emiCalculator");
var emiRouter = require("./userEmi")
var privacyRouter = require("./privacyPolicy")
var appUpdateRouter = require("./appUpdate")

var app = express();
// user Apis
app.use("/user/user-loans/",userUserLoanRouter);

app.use("/auth/", authRouter);
app.use("/user/", userRouter);
app.use("/loan/", loanRouter);
app.use('/loan-status/', loanStatusRouter);
app.use('/emi-status/', emiStatusRouter);
app.use("/loan-type/", loanTypeRouter);
app.use("/user-loan/", userLoanRouter);
app.use("/payment/", paymentRouter);
app.use("/language/", languageRouter);
app.use("/notification/", NotificationRouter);
app.use("/residential-type/", residentialTypeRouter);
app.use("/loan-banner/", loanBannerRouter);
app.use("/offer-banner/", offerBannerRouter);
app.use("/admin/", adminRouter);
app.use("/job-type/", jobTypeRouter);
app.use("/profile/", profileRouter);
app.use('/cibil/',userCibilRouter);
app.use('/user/loan-emi/', userEmiRouter)
app.use('/user/emi-calculator/', emiCalculatorRouter)
app.use('/rate-us/', rateUsRouter)
app.use('/loan-emi/', emiRouter)
app.use('/privacy-policy/', privacyRouter)
app.use('/app-update/', appUpdateRouter)


module.exports = app;