const RateUs = require("../../models/RateUsModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../../helpers/apiResponse");
const auth = require("../../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);


 exports.rateUsLists = [
	auth,
	function (req, res) {
        console.log('In req')
		try {
            
			RateUs.findOne({user : mongoose.Types.ObjectId(req.user._id)}).populate([
                {   path :'user' , 
                    model : 'User'
                },
              ]).then((rateUs)=>{
                // console.log(req)
                // console.log(rateUs)
				if(rateUs){
					return apiResponse.successResponseWithData(res, "Operation success", rateUs);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) { 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];



exports.rateUsStore = [
	auth,
    body("rate").isLength({ min: 1 }).trim().withMessage("Loan id must be specified.")
       .isNumeric().withMessage("Rate must be numeric value"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
                    RateUs.findOne({user : req.user._id}, function(err, rate){
                        if(err){
                            if(err) { return apiResponse.ErrorResponse(res, err);}
                        }
                        if(!rate){
                            var rateUs = new RateUs(
                                {
                                   user : req.user._id,
                                   rate : req.body.rate
                                }
                            )
        
                            rateUs.save(function(err){
                                if(err) { return apiResponse.ErrorResponse(err, rateApp);}
                                   
                                RateUs.findOne({_id : rate._id}).populate([
                                    {
                                        path: "user",
                                        model: "User",
                                    },
                                    ]).then((data) => {
                                    return apiResponse.successResponseWithData(res,"Rate us undated.", data);
                                }).catch((err) => {
                                    return apiResponse.ErrorResponse(res, err);
                                })    
                            })
                        }
                        else{
                            var updateRateUs = {
                                   user : req.user._id,
                                   rate : req.body.rate
                                }
                            
        
                            RateUs.updateOne({user : req.user._id} , updateRateUs, function(err, update){
                                if(err) { return apiResponse.ErrorResponse(res, err);}
                                   
                                RateUs.findOne({_id : rate._id}).populate([
                                    {
                                        path: "user",
                                        model: "User",
                                    },
                                    ]).then((data) => {
                                    return apiResponse.successResponseWithData(res,"Rate us undated.", data);
                                }).catch((err) => {
                                    return apiResponse.ErrorResponse(res, err);
                                })    
                            })
                        }
                    })
                    
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

