
const { body,validationResult , check} = require("express-validator");
const { sanitizeBody } = require("express-validator");
const auth = require("../../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const Loan = require("../../models/LoanModel");
const apiResponse = require("../../helpers/apiResponse");


exports.getCalculated = [
	auth,
	body("amount").isLength({ min : 1 }).trim().withMessage("Amount must be specified.").isInt({ min:1000}).withMessage("Amount must be equal or greater than 1000"),
	body("durationMonth").isLength({ min : 1 }).trim().withMessage("Duration Month must be specified.").isNumeric().withMessage("Duration must be numeric value"),
    body("durationYear").isLength({ min : 1 }).trim().withMessage("Duration Year must be specified.").isNumeric().withMessage("Duration must be numeric value"),
	body("interest").isLength({ min : 1 }).withMessage("Interest be required and minimum 3 character long").isNumeric().withMessage("Interest must be numeric value"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				Loan.findOne({
                    "durationWithInterest.monthDuration" : req.body.durationMonth,
                    "durationWithInterest.yearDuration" : req.body.durationYear,
                    "durationWithInterest.interest" : req.body.interest,
                    // minAmount : { $gte :  req.body.amount},
                    maxAmount : { $lte :  req.body.amount + 1}, 
                }, function(err, data){
                    
                    if(err){
                        if(err) { return apiResponse.ErrorResponse(res, err);}
                    }
                    if(data){
                        var month = parseInt(req.body.durationMonth);
                        let year = parseInt(req.body.durationYear),
                        duration = month + (year * 12);
                        let interest = parseInt(req.body.interest);
                        let amount = parseInt(req.body.amount);
                        let emi = (amount + (amount * interest/100))/duration;

                        let payload = {
                            durationMonth : req.body.durationMonth,
                            durationYear : req.body.durationYear,
                            interest : interest,
                            amount : amount,
                            emi : emi
                        }
                        return apiResponse.successResponseWithData(res,"EMI calculated.", payload);
                    }
                    else{
                        return apiResponse.successResponseWithData(res,"EMI not calculated.", {});
                    }
                })
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


