const User = require("../models/UserModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");

exports.changePassword = [
	body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified.")
	.isLength({min : 6}).withMessage("Password should be minimum 6 character long."),
	body("confirmPassword").isLength({ min: 1 }).trim().withMessage("Confirm password must be specified.")
	.isLength({min : 6}).withMessage("Confirm password should be minimum 6 character long."),
	sanitizeBody("password").escape(),
	sanitizeBody("confirmPassword").escape(),
(req, res) => {
	try {
		const errors = validationResult(req);
		if (!errors.isEmpty()) {
			return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
		} else if(req.body.password !== req.body.confirmPassword){
			return apiResponse.validationErrorWithData(res, "Confirm password should be equal to password", ['Confirm password should be equal to password']);
		}
		else {
            User.findById(req.user._id).then(user => {
                if (user) {
                    bcrypt.hash(req.body.password,10,function(err, hash){
                        //Compare given password with db's hash.
                        let html = "<p>Your password changed successfully. </p>";
                        // Send confirmation email
                        mailer.send(
                            constants.confirmEmails.from,
                            user.email,
                            "Changed Password",
                            html
                        ).then(function(){
                            User.findByIdAndUpdate(user._id,{password : hash, resetOtp : null},{}, function(err){
                            return apiResponse.successResponseWithData(res,"Password chnaged successfully on email.",[]);
                            })
                        })
                    })
                }else{
                    return apiResponse.unauthorizedResponse(res, "No user found related to this mobile number.");
                }
            });
		}
	} catch (err) {
		return apiResponse.ErrorResponse(res, err);
	}
}];

exports.updateProfile = [
	auth,
	body("firstName").isLength({ min: 1 }).trim().withMessage("First name must be specified.")
		.isAlphanumeric().withMessage("First name has non-alphanumeric characters."),
	body("lastName").isLength({ min: 1 }).trim().withMessage("Last name must be specified.")
		.isAlphanumeric().withMessage("Last name has non-alphanumeric characters."),
	body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
		.isEmail().withMessage("Email must be a valid email address."),
	function (req, res) {
        try {
            const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			} else{
                var user = {
                    _id : req.user._id,
                    firstName : req.body.firstName,
                    lastName : req.body.lastName,
                    email : req.body.email,
                }

                return apiResponse.successResponseWithData(res, "Your profile information", user);  
            }
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

