const ResidentialType = require("../models/ResidentialTypeModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");

// Book Schema
function ResidentialTypeData(data) {
	this.id = data._id;
	this.name= data.name;
}

/**
 * Book List.
 * 
 * @returns {Object}
 */
exports.residentialTypeList = [
	auth,
	function (req, res) {
		try {
			ResidentialType.find({},"_id name createdAt").then((residentialTypes)=>{
				if(residentialTypes.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", residentialTypes);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.residentialTypeDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			ResidentialType.findOne({_id: req.params.id},"_id name createdAt").then((residentialType)=>{                
				if(residentialType !== null){
					let residentialTypeData = new ResidentialTypeData(residentialType);
					return apiResponse.successResponseWithData(res, "Operation success", residentialTypeData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.residentialTypeStore = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must me minimum 2 characters long."),
	sanitizeBody("name").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {

					// Create User object with escaped and trimmed data
					var residentialType = new ResidentialType(
						{
							name: req.body.name,
						}
					);
						// Save user.
						residentialType.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							let residentialTypeData = {
								_id: residentialType._id,
								name: residentialType.name,
							};
							return apiResponse.successResponseWithData(res,"Residential Type Created.", residentialTypeData);
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book update.
 * 
 * @param {string}      title 
 * @param {string}      description
 * @param {string}      isbn
 * 
 * @returns {Object}
 */
exports.residentialTypeUpdate = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must be at least 2 characters long."),
	sanitizeBody("name").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					ResidentialType.findById(req.params.id, function (err, foundResidentialType) {
						if(foundResidentialType === null){
							return apiResponse.notFoundResponse(res,"Residential Type not exists with this id");
						}else{

							var residentialType = new ResidentialType(
								{
									name: req.body.name,
									_id:req.params.id
								}
							);
				
                            ResidentialType.findByIdAndUpdate(req.params.id, residentialType, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{
										let residentialTypeData = new ResidentialTypeData(residentialType);
										return apiResponse.successResponseWithData(res,"Residential Type update Success.", residentialTypeData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Delete.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.residentialTypeDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			ResidentialType.findById(req.params.id, function (err, foundResidentialType) {
				if(foundResidentialType === null){
					return apiResponse.notFoundResponse(res,"Residential Type not exists with this id");
				}else{
						//delete book.
						ResidentialType.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Residential Type delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.residentialTypeBulkDelete = [
	auth,
	function (req, res) {
		console.log(req.body.address_types)
        if(!Array.isArray(req.body.address_types)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.address_types.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.address_types[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }
		try {
            ResidentialType.deleteMany({ _id : {$in : req.body.address_types}}).then(result => {
                return apiResponse.successResponse(res,"Address types delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];