const User = require("../models/UserModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const mailer = require("../helpers/mailer");
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");


exports.myProfile = [
	auth,
	function (req, res) {
		try {
            User.findById(req.user._id, function (err, foundUser){
                if(foundUser === null){
                    return apiResponse.notFoundResponse(res,"User not exist with this auth");
                }else{
                    var user = {
                        _id : foundUser._id,
                        firstName : foundUser.firstName,
                        lastName : foundUser.lastName,
                        email : foundUser.email,
                        mobileNumber : foundUser.mobileNumber,
                        dob : foundUser.dob,
                        panCard : foundUser.panCard,
                        role : foundUser.role,
                        isConfirmed : foundUser.isConfirmed,
                        status : foundUser.status,
                    }

                    return apiResponse.successResponseWithData(res, "Your profile information", user);
                }
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.updateProfile = [
	auth,
    body("firstName").isLength({ min: 1 }).trim().withMessage("First name must be specified.")
		.isAlphanumeric().withMessage("First name has non-alphanumeric characters."),
	body("lastName").isLength({ min: 1 }).trim().withMessage("Last name must be specified.")
		.isAlphanumeric().withMessage("Last name has non-alphanumeric characters."),
	// body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
	// 	.isEmail().withMessage("Email must be a valid email address."),
	body("mobileNumber").isLength({min : 1}).trim().withMessage("Mobile number is required").isNumeric().withMessage("Mobile number should be numeric").isMobilePhone().withMessage("Mobile number is invalid"),
    sanitizeBody("firstName").escape(),
	sanitizeBody("lastName").escape(),
	// sanitizeBody("email").escape(),
    sanitizeBody("mobileNumber").escape(),
	function (req, res) {
		try {
            const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			} else{
                
                var updateUser = {
                    firstName : req.body.firstName,
                    lastName : req.body.lastName,
                    // email : req.body.email,
                    mobileNumber : req.body.mobileNumber,
                    // dob : req.body.dob,
                    // panCard : req.body.panCard,
                }

                if(req.body.email !== '' && req.body.email !== undefined){
                    updateUser['email'] = req.body.email;
                }
                if(req.body.dob !== ''  && req.body.dob !== undefined){
                    updateUser['dob'] = req.body.dob;
                }
                // if(re.body.mobileNumber !== ''){
                //     updateUser['mobileNumber'] = req.body.mobileNumber;
                // }
                if(req.body.panCard !== '' && req.body.panCard !== undefined){
                    updateUser['panCard'] = req.body.panCard;
                }

                // console.log(updateUser)

                User.updateOne({_id : req.user._id}, updateUser, function(err, updatedUser){
                   if(err){
                    // console.log(err)
                    return apiResponse.ErrorResponse(res, err);
                   }
                   User.findOne({_id : req.user._id}, "fistName lastName email mobileNumber role isConfirmed otp dob panCard status createdAt", function(error, newUser){
                        if(error){
                            return apiResponse.ErrorResponse(res, error);
                        }
                        return apiResponse.successResponseWithData(res, "Your profile updated successfully.", newUser); 
                   })
                    
                })
                
            }
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.changeMyPassword = [
	body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified.")
	.isLength({min : 6}).withMessage("Password should be minimum 6 character long."),
	body("confirmPassword").isLength({ min: 1 }).trim().withMessage("Confirm password must be specified.")
	.isLength({min : 6}).withMessage("Confirm password should be minimum 6 character long."),
	sanitizeBody("password").escape(),
	sanitizeBody("confirmPassword").escape(),
(req, res) => {
	try {
		const errors = validationResult(req);
		if (!errors.isEmpty()) {
			return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
		} else if(req.body.password !== req.body.confirmPassword){
			return apiResponse.validationErrorWithData(res, "Confirm password should be equal to password", ['Confirm password should be equal to password']);
		}
		else {
            User.findById(req.user._id).then(user => {
                if (user) {
                    bcrypt.hash(req.body.password,10,function(err, hash){
                        //Compare given password with db's hash.
                        let html = "<p>Your password changed successfully. </p>";
                        // Send confirmation email
                        mailer.send(
                            constants.confirmEmails.from,
                            user.email,
                            "Changed Password",
                            html
                        ).then(function(){
                            User.findByIdAndUpdate(user._id,{password : hash, resetOtp : null},{}, function(err){
                            return apiResponse.successResponseWithData(res,"Password chnaged successfully on email.",[]);
                            })
                        })
                    })
                }else{
                    return apiResponse.unauthorizedResponse(res, "No user found related to this mobile number.");
                }
            });
		}
	} catch (err) {
		return apiResponse.ErrorResponse(res, err);
	}
}];