const Notify = require("../models/NotificationModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);


// Book Schema
function NotifyData(data) {
	this.id = data._id;
	this.user = data.user;
    this.title = data.title;
    this.description = data.description
}

/**
 * Book List.
 * 
 * @returns {Object}
 */

 exports.notifyUserList = [
	auth,
	function (req, res) {
		try {
			Notify.find({user : mongoose. Types. ObjectId(req.user._id)},"_id user title description createdAt").populate("user").then((notifys)=>{
				if(notifys.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", notifys);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.notifyList = [
	auth,
	function (req, res) {
		try {
 
			Notify.find({},"_id user title description createdAt").populate("user").then((notifys)=>{
				if(notifys.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", notifys);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.notifyDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			Notify.findOne({_id: req.params.id},"_id user title description createdAt").populate("user").then((notify)=>{                
				if(notify !== null){
					let notifyData = new NotifyData(notify);
					return apiResponse.successResponseWithData(res, "Operation success", notifyData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.notifyStore = [
	auth,
	body("title").isLength({ min: 1 }).trim().withMessage("Title must be specified.")
		.isLength({min : 2}).withMessage("Title must me minimum 2 characters long."),
    body("description").isLength({ min: 1 }).trim().withMessage("Description must be specified.")
		.isLength({min : 2}).withMessage("Description must me minimum 2 characters long."),
    body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
		.isMongoId().withMessage("User id is invalid"),
	sanitizeBody("title").escape(),
    sanitizeBody("description").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {

					// Create User object with escaped and trimmed data
					var notify = new Notify(
						{
							title: req.body.title,
                            description : req.body.description,
                            user : req.body.user,
						}
					);
						// Save user.
						notify.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							let notifyData = {
								_id: notify._id,
								title: notify.title,
                                description : notify.description
							};
							return apiResponse.successResponseWithData(res,"Notification Created.", notifyData);
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book update.
 * 
 * @param {string}      title 
 * @param {string}      description
 * @param {string}      isbn
 * 
 * @returns {Object}
 */
exports.notifyUpdate = [
	auth,
	body("title").isLength({ min: 1 }).trim().withMessage("Title must be specified.")
		.isLength({min : 2}).withMessage("Title must me minimum 2 characters long."),
    body("description").isLength({ min: 1 }).trim().withMessage("Description must be specified.")
		.isLength({min : 2}).withMessage("Description must me minimum 2 characters long."),
    body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
		.isMongoId().withMessage("User id is invalid"),
	sanitizeBody("title").escape(),
    sanitizeBody("description").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					Notify.findById(req.params.id, function (err, foundNotify) {
						if(foundNotify === null){
							return apiResponse.notFoundResponse(res,"Notification not exists with this id");
						}else{

							var notify = new Notify(
								{
									title: req.body.title,
									_id:req.params.id,
                                    description : req.body.description
								}
							);
				
								Notify.findByIdAndUpdate(req.params.id, notify, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{

                                        Notify.findById(req.params.id).populate('user').then((data) => {
                                            return apiResponse.successResponseWithData(res,"Notification update Success.", data);
                                        })
										// let notifyData = new NotifyData(notify);
										// return apiResponse.successResponseWithData(res,"Notification update Success.", notifyData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Delete.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.notifyDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			Notify.findById(req.params.id, function (err, foundNotify) {
				if(foundNotify === null){
					return apiResponse.notFoundResponse(res,"Notification not exists with this id");
				}else{
						//delete book.
						Notify.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Notification delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.notifyBulkDelete = [
	auth,
	function (req, res) {
		console.log(req.body.notifications)
        if(!Array.isArray(req.body.notifications)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.notifications.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.notifications[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }
		try {
            Notify.deleteMany({ _id : {$in : req.body.notifications}}).then(result => {
                return apiResponse.successResponse(res,"Notifications delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];