const Status = require("../models/LoanStatusModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);


function StatusData(data) {
	this.id = data._id;
	this.name = data.name;
    this.color = data.color;
}

exports.statusList = [
	auth,
	function (req, res) {
		try {
 
			Status.find({},"_id name color createdAt").then((statuses)=>{
				if(statuses.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", statuses);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.statusDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			Status.findOne({_id: req.params.id},"_id name createdAt").then((status)=>{                
				if(status !== null){
					let statusData = new StatusData(status);
					return apiResponse.successResponseWithData(res, "Operation success", statusData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.statusStore = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must me minimum 2 characters long."),
    body("color").isLength({ min: 1 }).trim().withMessage("Color must be specified.")
		.isLength({min : 3}).withMessage("Color must me minimum 2 characters long."),
	sanitizeBody("name").escape(),
    sanitizeBody("color").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
					// Create User object with escaped and trimmed data
					var status = new Status(
						{
							name: req.body.name,
                            color : req.body.color,
						}
					);
						// Save status.
						status.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							let statusData = {
								_id: status._id,
								name: status.name,
                                color : status.color,
                                createdAt : new Date(),
							};
							return apiResponse.successResponseWithData(res,"Status Created.", statusData);
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.statusUpdate = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must me minimum 2 characters long."),
    body("color").isLength({ min: 1 }).trim().withMessage("Color must be specified.")
		.isLength({min : 3}).withMessage("Color must me minimum 3 characters long."),
	sanitizeBody("name").escape(),
    sanitizeBody("color").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					Status.findById(req.params.id, function (err, foundStatus) {
						if(foundStatus === null){
							return apiResponse.notFoundResponse(res,"Status not exists with this id");
						}else{

							var status = new Status(
								{
									_id:req.params.id,
                                    name: req.body.name,
                                    color : req.body.color
								}
							);
				
								Status.findByIdAndUpdate(req.params.id, status, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{

                                        Status.findById(req.params.id).then((data) => {
                                            return apiResponse.successResponseWithData(res,"Status update Success.", data);
                                        })
										// let notifyData = new NotifyData(notify);
										// return apiResponse.successResponseWithData(res,"Notification update Success.", notifyData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.statusDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			Status.findById(req.params.id, function (err, foundStatus) {
				if(foundStatus === null){
					return apiResponse.notFoundResponse(res,"Notification not exists with this id");
				}else{
						//delete book.
						Status.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Status delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.statusBulkDelete = [
	auth,
	function (req, res) {

        if(!Array.isArray(req.body.statuses)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.statuses.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.statuses[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }
		try {
            Status.deleteMany({ _id : {$in : req.body.statuses}}).then(result => {
                return apiResponse.successResponse(res,"Status delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];