var express = require("express");
const UserController = require("../controllers/UserController");
const utility = require("../helpers/utility");

var router = express.Router();

router.get("/", UserController.userList,utility.unAuth);
router.get("/:id", UserController.userDetail,utility.unAuth);
router.post("/", UserController.userStore,utility.unAuth);
router.put("/:id", UserController.userUpdate,utility.unAuth);
router.delete("/:id", UserController.userDelete,utility.unAuth);
router.post("/bulk-delete", UserController.userBulkDelete,utility.unAuth);


module.exports = router;