var express = require("express");
const AuthController = require("../controllers/AuthController");
const { default: axios } = require("axios");


var router = express.Router();

router.post("/register", AuthController.register);
router.post("/login", AuthController.login);
router.post("/admin/login", AuthController.adminLogin);
router.post("/login/verify-otp", AuthController.confirmOtp);

router.post("/savefist", AuthController.savefist);
router.post("/savesecond", AuthController.savesecond);
router.post("/savethird", AuthController.savethird);


router.post("/verify-otp", AuthController.verifyConfirm);
router.post("/resend-verify-otp", AuthController.resendConfirmOtp);
router.post("/login/verify-otp", AuthController.verifyLoginConfirm);
router.post("/forgot-password",AuthController.forgotPassword);
router.post("/reset-password", AuthController.resetPassword);
router.post("/change-password", AuthController.changePassword);

// //
router.post('/send-otp', AuthController.sendcreditotp);

router.post('/check-credit-score', AuthController.checkcredit);

module.exports = router;