var mongoose = require("mongoose");

var UserSchema = new mongoose.Schema({
	head: {type: String, required: false, default : null},
	firstName: {type: String, required: false, default : null},
	lastName: {type: String, required: false, default : null},
	email: {type: String, required: false, default : null},
	mobileNumber :{type : Number, required : false, default : null},
	password: {type: String, required: false, default : null},
	role:{type: String, required : false, default : "user"},
	isConfirmed: {type: Boolean, required: true, default: false},
	confirmOTP: {type: String, required:false},
	otp: {type: Number, required: false, default: null},
	resetOtp:{type : String, required : false},
	otpTries: {type: Number, required:false, default: 0},
	dob:{type : Date, required : false, default : null},
	pincode:{type : Date, required : false, default : null},
	panCard:{type: String, required : false, default : null},
	status: {type: Boolean, required: true, default: 1}
}, {timestamps: true});

// Virtual for user's full name
UserSchema
	.virtual("fullName")
	.get(function () {
		return this.firstName + " " + this.lastName;
	});

module.exports = mongoose.model("User", UserSchema);
