
var mongoose = require("mongoose");
const ResidentialType = require('./ResidentialTypeModel')

var UserLoanSchema = new mongoose.Schema({
	loanId :{type: String, required : false, default : (Math.random() + 1).toString(36).substring(5).toUpperCase()},
	loan: {type: mongoose.Schema.ObjectId, ref: "Loan", required: true},
	user: {type: mongoose.Schema.ObjectId, ref: "User", required: true},
	residentialType: {type: mongoose.Schema.ObjectId, ref: "ResidentialType", required: true},
    loanAddress: {type: mongoose.Schema.ObjectId, ref: "LoanAddress", required: true},
	amount: {type: Number, required: true},
	monthlyIncome :{type : Number, required : true},
	companyName: {type: String, required: true},
	durationMonth:{type: Number, required : true},
    durationYear:{type: Number, required : true},
	dueDate:{type:Date, required:false, default : null},
	approved : {type : Boolean, required : false, default : false},
	approvedDate : {type: Date, required: false, default : null},
	status:{type: mongoose.Schema.ObjectId, ref: "LoanStatus", required: true, default : "631b9752d303063a10a3455b"},
}, {timestamps: true});


module.exports = mongoose.model("UserLoan", UserLoanSchema);