const { Decimal128 } = require("mongoose");
var mongoose = require("mongoose");

var LoanSchema = new mongoose.Schema({
	loanType: {type: mongoose.Schema.ObjectId, ref: "LoanType", required: true},
	name : {type : String, required : true},
	minAmount: {type: Number, required: true},
	maxAmount: {type: Number, required: true},
	// monthDuration :{type : Number, required : false, default : null},
	// yearDuration: {type: Number, required: true},
	// interest:{type: Number, required : true},
	durationWithInterest:[{ 
		monthDuration : {type : Number, default : 0, required : false},
		yearDuration : {type : Number, default : 0, required : false},
		interest : {type : Number, required : true}
	}],
	description:{type: String, required : false, default : ''}
}, {timestamps: true});


module.exports = mongoose.model("Loan", LoanSchema);