const UserLoan = require("../../models/UserLoanModel");
const LoanAddress = require("../../models/LoanAddressModel");
const CibilModel = require("../../models/UserCibilModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../../helpers/apiResponse");
const auth = require("../../middlewares/jwt");
const axios = require('axios')
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);


const isValidDate = (dateString) =>  {
    var regEx = /^\d{4}-\d{2}-\d{2}$/;
    if(!dateString.match(regEx)) return false;  // Invalid format
    var d = new Date(dateString);
    var dNum = d.getTime();
    if(!dNum && dNum !== 0) return false; // NaN value, Invalid date
    return d.toISOString().slice(0,10) === dateString;
}

exports.getUserCivilScore = [
	auth,
    body("firstName").isLength({ min: 1 }).trim().withMessage("First name must be specified.")
        .isLength({min : 2}).withMessage("First name at least 2 character long"),
    // body("middleName").isLength({ min: 1 }).trim().withMessage("Middle Name must be specified.")
    //     .isLength({min : 2}).withMessage("Middle name at least 2 character long"),
    body("lastName").isLength({ min: 1 }).trim().withMessage("Locality must be specified.")
        .isLength({min : 2}).withMessage("Last name at least 2 character long"),
    body("transactionAmount").isLength({ min: 1 }).trim().withMessage("Transaction amount must be specified.")
        .isNumeric().withMessage("Transaction amount must be numeric value")
        .isLength({min : 4 , max: 15}).withMessage("Transaction amount must be at least 4 digit long"),
    body("phone").isLength({ min: 1 }).trim().withMessage("Phone number must be specified.")
        .isLength({min : 10}).withMessage("Phone number at least 2 character long")
        .isNumeric().withMessage("Phone number must be in numeric format"),
    body("phoneType").isLength({ min: 1 }).trim().withMessage("Phone type must be specified."),
    body("email").isLength({ min: 1 }).trim().withMessage("Email address must be specified.")
        .isEmail().withMessage("Invalid email address"),
    body("emailType").isLength({ min: 1 }).trim().withMessage("Email type must be specified."),
    body("dob").isLength({ min: 1 }).trim().withMessage("Date of birth must be specified."),
        // .custom((dob) => {
        //     if(!isValidDate(dob)){
        //         return Promise.reject("Dob not valid date");
        //     }
        //     else{ 
        //         return Promise.Accept;
        //     }
		// }),
    
    body("idNumber").isLength({ min: 1 }).trim().withMessage("Id number must be specified.")
        .isLength({min : 2}).withMessage("Id number at least 2 character long"),
    body("idType").isLength({ min: 1 }).trim().withMessage("Id type must be specified."),
    body("gender").isLength({ min: 1 }).trim().withMessage("Gender must be specified."),
    body("address").isLength({ min: 1 }).trim().withMessage("Address must be specified.")
        .isLength({min : 10, max : 200}).withMessage("Address should be minimum 10 and maximum 200 character long."),
    body("addressType").isLength({ min: 1 }).trim().withMessage("Address type must be specified."),
    body("state").isLength({ min: 1 }).trim().withMessage("state must be specified.")
        .isLength({min : 2}).withMessage("State least 2 character long"),
    body("city").isLength({ min: 1 }).trim().withMessage("City must be specified.")
        .isLength({min : 2}).withMessage("City at least 2 character long"),
    body("locality").isLength({ min: 1 }).trim().withMessage("Locality must be specified.")
        .isLength({min : 2}).withMessage("locality at least 2 character long"),
    body("pincode").isLength({ min: 1 }).trim().withMessage("Pincode must be specified.")
        .isLength({min : 6}).withMessage("Pincode at least 2 character long")
        .isNumeric().withMessage("Pincode should be numeric"),
	async (req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {

                // console.log('INNNNNN')
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {
                    InquiryPurpose : "00",
                    TransactionAmount : req.body.transactionAmount,
                    FirstName : req.body.firstName,
                    MiddleName : req.body.middleName ?? "",
                    LastName: req.body.lastName,
                    InquiryAddresses:[{
                        seq: "1",
                        AddressLine1 : req.body.address,
                        AddressLine2 :"",
                        Locality: req.body.locality,
                        City: req.body.city,
                        State: req.body.state,
                        AddressType:[req.body.addressType],
                        Postal: req.body.pincode
                    }],
                    InquiryPhones: [{
                        seq:"1",
                        Number: req.body.phone,
                        PhoneType:[req.body.phoneType]
                    }],
                    EmailAddresses :[{
                        seq:"1",
                        Email: req.body.email,
                        EmailType: [req.body.emailType]
                    }],
                    IDDetails :[{
                        seq:"1",
                        IDValue: req.body.idNumber,
                        IDType: req.body.idType
                    }],
                    DOB: req.body.dob,
                    Gender: req.body.gender
                };

                // console.log(data);


                await axios.post(`https://ezulix.in/api/Cibil/CallAPI.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                    // console.log(response.data)
                   if(response.data.status){
                    let newReport = CibilModel({user:req.doc.id,cibilReport:response.data})
                    return apiResponse.successResponseWithData(res, "Operation success", response.data.response);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                   
                })
                .catch((err) => {
                    // console.log(err)
                    return apiResponse.ErrorResponse(res, err);
                })
				
			}
		} catch (err) {
            // console.log(err)
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getCivilEnquiryType = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getinquirytype"} ;
				await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                    // console.log('INININ')
                    // console.log(response.status)
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                   
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getCivilState = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getstate"} ;
				await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                   
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getIdType = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getidtype"} ;
				await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getPhoneType = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getphonetype"} ;
				await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                   
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getAddressType = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getaddresstype"} ;
				await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.getGenderType = [auth,
	async(req, res) => {
		try {
				let memberId = process.env.CIBIL_MEMBER_ID;
                let cibilToken = process.env.CIBIL_API_KEY;
                let data = {methodname:"getgendertype"} ;
                await axios.post(`https://ezulix.in/api/Cibil/GetMasterData.aspx?memberid=${memberId}&apikey=${cibilToken}`, data)
                .then(function(response) {
                   if(response.status === 200){
                    return apiResponse.successResponseWithData(res, "Operation success", response.data);
                   }
                   else{
                    res.send({status : 0, message : response.data.response[0], data : response.data.response});
                   }
                })
                .catch((err) => {
                    return apiResponse.ErrorResponse(res, err);
                })
				

		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];




