const UserLoan = require("../models/UserLoanModel");
const UserEmi = require("../models/UserEmiModel");
const LoanAddress = require("../models/LoanAddressModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
const UserEmiModel = require("../models/UserEmiModel");
mongoose.set("useFindAndModify", false);


// Book Schema
function UserLoanData(data) {
	this.id = data._id;
    this.loan = data.loan;
    this.loanId = data.loanId;
	this.user = data.user;
    this.residentialType = data.residentialType;
    this.loanAddress = data.loanAddress,
    this.amount = data.amount,
    this.monthlyIncome = data.monthlyIncome,
    this.companyName = data.companyName,
    this.durationMonth = data.durationMonth,
    this.durationYear = data.durationYear
}

/**
 * Book List.
 * 
 * @returns {Object}
 */

 exports.userLoanList = [
	auth,
	function (req, res) {
		try {
			UserLoan.find({user : mongoose. Types. ObjectId(req.user._id)},"_id loan user residentialType loanAddress amount monthlyIncome companyName durationMonth durationYear createdAt").populate([{ path: "loan",model: "Loan"},{path: "user",model: "User"},{path: "loanAddress",model: "LoanAddress"},{path: "residentialType",model: "ResidentialType"}]).then((userLoans)=>{
				if(userLoans.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", userLoans);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.loanApproval = [
        auth,
        body("approved").isBoolean().trim().withMessage("Approved boolean value must be specified."),
        (req, res) => {
            try {
                const errors = validationResult(req);
                if (!errors.isEmpty()) {
                    return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
                }
                if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}
                else {

                    var updateData = {
                        approved : req.body.approved, 
                        approvedDate : new Date()
                    }
                    UserLoan.findByIdAndUpdate(req.params.id, updateData, function(err, data){
                        if (err) { 
                            return apiResponse.ErrorResponse(res, err); 
                        }
                        else{

                          UserLoan.findById(req.params.id).populate([
                            {
                                path: "loan",
                                model: "Loan",
                                
                            },
                            {
                                path: "user",
                                model: "User",
                            },
                            {
                                path: "loanAddress",
                                model: "LoanAddress",
                            },
                            {
                                path: "residentialType",
                                model: "ResidentialType",
                            },
                            ]).then((data) => {
                                UserEmi.findOne({loan : req.params.id}, function(er, emi){
                                    if(er){
                                        return apiResponse.ErrorResponse(res, err); 
                                    }

                                    if(emi === null){
                                        // data = data[0];
                                        let month = data.durationMonth + (data.durationYear != 0 ? (data.durationYear * 12) : 0);
                                        let interest = data.loan.durationWithInterest.filter((item) => item.monthDuration == data.durationMonth && item.yearDuration == data.durationYear)[0].interest;
                                        let date = new Date()
                                        // console.log('MONTH-', month)
                                        // console.log('INTEREST -------',interest);
                                    
                                        var total = Math.ceil(data.amount + (data.amount * (interest/100)));
                                        var emi = Math.ceil(total/month);
                                        var dueDate = null;
                                        var arr = [];
                                        for(var i = 0; i < month ; i++){
                                            // var newDate = new Date(date.getFullYear() +'-' + ( date.getMonth() + (i+ 1)) + '-' + date.getDate());
                                            var dynamicMonth = date.getMonth() + ( i + 2);
                                            var year = date.getFullYear();
                                            if(dynamicMonth > 12){
                                                year = year + 1;
                                            dynamicMonth = dynamicMonth - 12;
                                            }
                                            
                                            var newDate = new Date(year + '-' + dynamicMonth + '-' + date.getDate());
                                            // console.log(newDate)
                                        
                                            
                                            var obj = {
                                                user : data.user._id,
                                                loan : data._id,
                                                dueDate : newDate,
                                                amount : emi,
                                                paidDate : null,
                                                paidBy :  null,
                                                payment : null
                                            };
                                            arr.push(obj);
                                            dueDate = newDate;
                                        }

                                        // console.log(arr)

                                        UserLoan.updateOne({_id :req.params.id },{dueDate : dueDate, status : '631b977ed303063a10a3455d'}, function(errr, loan){
                                            if(errr){
                                                return apiResponse.ErrorResponse(res, err); 
                                            }
                                        })

                                        UserEmi.insertMany(arr, function(err, data){
                                            if(err){
                                                return apiResponse.ErrorResponse(res, err); 
                                            }
                                            else{
                                                return apiResponse.successResponseWithData(res,"User Loan approved status changed.", data);
                                            }
                                        })
                                    }
                                    else{
                                        return apiResponse.successResponseWithData(res,"User Loan approved status changed.", data);
                                    }
                                })
                               
                               
                            })
                        }
                    })
                }
            } catch (err) {
                //throw error in json response with status 500. 
                return apiResponse.ErrorResponse(res, err);
            }
        }
];
    

exports.myLoanList = [
	auth,
	function (req, res) {
		try {
			UserLoan.find({user : mongoose. Types. ObjectId(req.user._id)},"_id loan user residentialType loanAddress amount monthlyIncome companyName durationMonth durationYear createdAt").populate([{ path: "loan",model: "Loan"},{path: "user",model: "User"},{path: "loanAddress",model: "LoanAddress"},{path: "residentialType",model: "ResidentialType"}]).then((userLoans)=>{
				if(userLoans.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", userLoans);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.allUserLoanList = [
	auth,
	function (req, res) {
		try {
			UserLoan.find({},"_id loan user residentialType loanAddress amount monthlyIncome companyName durationMonth durationYear approved approvedDate dueDate status createdAt").populate([{ path: "loan",model: "Loan"},{path: "user",model: "User"},{path: "loanAddress",model: "LoanAddress"},{path: "residentialType",model: "ResidentialType"}]).then((userLoans)=>{
				if(userLoans.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", userLoans);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.userSpecificLoanList = [
	auth,
	function (req, res) {
		try {
			UserLoan.find({},"_id loan user residentialType loanAddress amount monthlyIncome companyName durationMonth durationYear createdAt").populate([{ path: "loan",model: "Loan"},{path: "user",model: "User"},{path: "loanAddress",model: "LoanAddress"},{path: "residentialType",model: "ResidentialType"}]).then((userLoans)=>{
				if(userLoans.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", userLoans);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.userLoanDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			UserLoan.findOne({_id: req.params.id},"_id loanId loan user residentialType loanAddress amount monthlyIncome companyName durationMonth durationYear createdAt").populate([{ path: "loan",model: "Loan"},{path: "user",model: "User"},{path: "loanAddress",model: "LoanAddress"},{path: "residentialType",model: "ResidentialType"}]).then((userLoan)=>{                
				if(userLoan !== null){
					let userLoanData = new UserLoanData(userLoan);
					return apiResponse.successResponseWithData(res, "Operation success", userLoanData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.userLoanStore = [
	auth,
    body("loan").isLength({ min: 1 }).trim().withMessage("Loan id must be specified.")
		.isMongoId().withMessage("Loan id is invalid."),
	body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
		.isMongoId().withMessage("User id is invalid."),
    body("residentialType").isLength({ min: 1 }).trim().withMessage("Residential Type must be specified.").isMongoId().withMessage("residentialType is invalid."),
    body("houseNo").isLength({ min: 1 }).trim().withMessage("House number must be specified.")
		.isLength({min : 2}).withMessage("House number at least 2 character long"),
    body("landmark").isLength({ min: 1 }).trim().withMessage("Landmark must be specified.")
		.isLength({min : 2}).withMessage("Landmark at least 2 character long"),
    body("locality").isLength({ min: 1 }).trim().withMessage("Locality must be specified.")
		.isLength({min : 2}).withMessage("Locality at least 2 character long"),
    body("pincode").isLength({ min: 1 }).trim().withMessage("Pincode must be specified.")
		.isNumeric().withMessage("Pincode must be numeric value")
        .isLength({min : 6 , max: 6}).withMessage("Pincode must be 6 character long"),
    body("city").isLength({ min: 1 }).trim().withMessage("City must be specified.")
		.isLength({min : 2}).withMessage("City at least 2 character long"),
    body("amount").isLength({ min: 1 }).trim().withMessage("Loan amount must be specified.")
		.isNumeric().withMessage("Loan amount should be numeric value"),
    body("monthlyIncome").isLength({ min: 1 }).trim().withMessage("Monthly Income must be specified.")
		.isNumeric().withMessage("Monthly Income should be numeric value"),
    body("companyName").isLength({ min: 1 }).trim().withMessage("Company name must be specified.")
		.isLength({min : 2}).withMessage("Company name at least 2 character long"),
    body("durationMonth").isLength({ min: 1 }).trim().withMessage("Month duration must be specified.")
		.isNumeric().withMessage("Month duration should be numeric value")
        .isLength({min : 0 , max : 12}).withMessage("Month duration value between 0 to 12"),
    body("durationYear").isLength({ min: 1 }).trim().withMessage("Year duration must be specified.")
		.isNumeric().withMessage("Year duration should be numeric value")
        .isLength({min : 0 , max : 40}).withMessage("Year duration value between 0 to 40"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
					// Create User object with escaped and trimmed data

                    var address = new LoanAddress(
                        {
                           user : req.body.user,
                           houseNo : req.body.houseNo,
                           landmark : req.body.landmark,
                           locality : req.body.locality,
                           pincode : req.body.pincode,
                           city : req.body.city
                        }
                    )

                    address.save(function(err){
                        if(err) { return apiResponse.ErrorResponse(res, err);}
                        // return apiResponse.successResponseWithData(res,"Address Created.", address);

                        var userLoan = new UserLoan(
                            {
                                loan : req.body.loan,
                                user : req.body.user,
                                residentialType : req.body.residentialType,
                                loanAddress : address._id,
                                amount : req.body.amount,
                                monthlyIncome : req.body.monthlyIncome,
                                companyName : req.body.companyName,
                                durationMonth : req.body.durationMonth,
                                durationYear : req.body.durationYear
                            }
                        );
                            // Save user loan.
                            userLoan.save(function (err) {
                                if (err) { return apiResponse.ErrorResponse(res, err); }
                                
                                UserLoan.find({_id : userLoan._id}).populate([
                                    {
                                      path: "loan",
                                      model: "Loan",
                                    },
                                    {
                                        path: "user",
                                        model: "User",
                                    },
                                    {
                                        path: "loanAddress",
                                        model: "LoanAddress",
                                    },
                                    {
                                        path: "residentialType",
                                        model: "ResidentialType",
                                    },
                                  ]).then((data) => {
                                    return apiResponse.successResponseWithData(res,"User Loan Created.", data);
                                }).catch((err) => {
                                    return apiResponse.ErrorResponse(res, err);
                                })
                                
                            });
                    })
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.userLoanUpdate = [
	auth,
    body("loan").isLength({ min: 1 }).trim().withMessage("Loan id must be specified.")
    .isMongoId().withMessage("Loan id is invalid."),
    body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
        .isMongoId().withMessage("User id is invalid."),
    body("residentialType").isLength({ min: 1 }).trim().withMessage("Residential Type must be specified.")
        .isMongoId().withMessage("residentialType is invalid."),
    body("houseNo").isLength({ min: 1 }).trim().withMessage("House number must be specified.")
        .isLength({min : 2}).withMessage("House number at least 2 character long"),
    body("landmark").isLength({ min: 1 }).trim().withMessage("Landmark must be specified.")
        .isLength({min : 2}).withMessage("Landmark at least 2 character long"),
    body("locality").isLength({ min: 1 }).trim().withMessage("Locality must be specified.")
        .isLength({min : 2}).withMessage("Locality at least 2 character long"),
    body("pincode").isLength({ min: 1 }).trim().withMessage("Pincode must be specified.")
        .isNumeric().withMessage("Pincode must be numeric value")
        .isLength({min : 6 , max: 6}).withMessage("Pincode must be 6 character long"),
    body("city").isLength({ min: 1 }).trim().withMessage("City must be specified.")
        .isLength({min : 2}).withMessage("City at least 2 character long"),
    body("amount").isLength({ min: 1 }).trim().withMessage("Loan amount must be specified.")
        .isNumeric().withMessage("Loan amount should be numeric value"),
    body("monthlyIncome").isLength({ min: 1 }).trim().withMessage("Monthly Income must be specified.")
        .isNumeric().withMessage("Monthly Income should be numeric value"),
    body("companyName").isLength({ min: 1 }).trim().withMessage("Company name must be specified.")
        .isLength({min : 2}).withMessage("Company name at least 2 character long"),
    body("durationMonth").isLength({ min: 1 }).trim().withMessage("Month duration must be specified.")
        .isNumeric().withMessage("Month duration should be numeric value")
        .isLength({min : 0 , max : 12}).withMessage("Month duration value between 0 to 12"),
    body("durationYear").isLength({ min: 1 }).trim().withMessage("Year duration must be specified.")
        .isNumeric().withMessage("Year duration should be numeric value")
        .isLength({min : 0 , max : 40}).withMessage("Year duration value between 0 to 40"),
	(req, res) => {
		try {
            
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					// Notify.findById(req.params.id, function (err, foundNotify) {
					// 	if(foundNotify === null){
					// 		return apiResponse.notFoundResponse(res,"User Loan not exists with this id");
					// 	}else{

                            var address = new LoanAddress(
                                {
                                   user : req.body.user,
                                   houseNo : req.body.houseNo,
                                   landmark : req.body.landmark,
                                   locality : req.body.locality,
                                   pincode : req.body.pincode,
                                   city : req.body.city
                                }
                            )
                            address.save(function(err){
                                console.log('I am in')
                                if(err) { return apiResponse.ErrorResponse(res, err);}

                                var userLoan = new UserLoan(
                                    {
                                        _id : req.params.id,
                                        loan : req.body.loan,
                                        user : req.body.user,
                                        residentialType : req.body.residentialType,
                                        loanAddress : address._id,
                                        amount : req.body.amount,
                                        monthlyIncome : req.body.monthlyIncome,
                                        companyName : req.body.companyName,
                                        durationMonth : req.body.durationMonth,
                                        durationYear : req.body.durationYear
                                    }
                                );
                    
                                UserLoan.findByIdAndUpdate(req.params.id, userLoan, {},function (err) {
                                    if (err) { 
                                        return apiResponse.ErrorResponse(res, err); 
                                    }else{
    
                                        UserLoan.findById(req.params.id).populate([
                                            {
                                                path: "loan",
                                                model: "Loan",
                                                
                                            },
                                            {
                                                path: "user",
                                                model: "User",
                                            },
                                            {
                                                path: "loanAddress",
                                                model: "LoanAddress",
                                            },
                                            {
                                                path: "residentialType",
                                                model: "ResidentialType",
                                            },
                                            ]).then((data) => {
                                            return apiResponse.successResponseWithData(res,"User Loan update Success.", data);
                                        })
                                        // let notifyData = new NotifyData(notify);
                                        // return apiResponse.successResponseWithData(res,"Notification update Success.", notifyData);
                                    }
                                });
                            })

							
				
						// }
					// });
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.userLoanDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}  
		try {
			UserLoan.findById(req.params.id, function (err, foundUserLoan) {
				if(foundUserLoan === null){
					return apiResponse.notFoundResponse(res,"User Loan not exists with this id");
				}else{
						//delete book.
						UserLoan.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"User Loan delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.userLoanBulkDelete = [
	auth,
	function (req, res) {
        if(!Array.isArray(req.body.loans)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.loans.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.loans[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }

		try {
            UserLoan.deleteMany({ _id : {$in : req.body.loans}}).then(result => {
                return apiResponse.successResponse(res,"User Loan delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];