const PrivacyPolicy = require("../models/PrivacyPolicyModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
var mongoose = require("mongoose");
const UserEmiModel = require("../models/UserEmiModel");
const auth = require("../middlewares/jwt");
mongoose.set("useFindAndModify", false);


 exports.privacyPolicyList = [
	auth,
	function (req, res) {
		try {
			PrivacyPolicy.findOne().then((policy)=>{
				if(policy){
					return apiResponse.successResponseWithData(res, "Operation success", policy);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.privacyPolicyStore = [
	auth,
    body("title").isLength({ min: 1 }).trim().withMessage("Title must be specified."),
    body("description").isLength({ min: 1 }).trim().withMessage("Description must be specified."),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
                    PrivacyPolicy.findOne({}, function(err, rate){
                        if(err){
                            if(err) { return apiResponse.ErrorResponse(res, err);}
                        }
                        if(!rate){
                            var privacyPolicy = new PrivacyPolicy(
                                {
                                   title : req.body.title,
                                   description : req.body.description
                                }
                            )
        
                            privacyPolicy.save(function(err){
                                if(err) { return apiResponse.ErrorResponse(err, rateApp);}
                                   
                                PrivacyPolicy.findOne({_id : privacyPolicy._id}).then((data) => {
                                    return apiResponse.successResponseWithData(res,"Privacy policy updated.", data);
                                }).catch((err) => {
                                    return apiResponse.ErrorResponse(res, err);
                                })    
                            })
                        }
                        else{
                            var updatePrivacyPolicy = {
                                    title : req.body.title,
                                    description : req.body.description
                                }
        
                            PrivacyPolicy.updateOne({user : rate._id} , updatePrivacyPolicy, function(err, update){
                                if(err) { return apiResponse.ErrorResponse(res, err);}
                                   
                                PrivacyPolicy.findOne({_id : rate._id}).then((data) => {
                                    return apiResponse.successResponseWithData(res,"Privacy policy undated.", data);
                                }).catch((err) => {
                                    return apiResponse.ErrorResponse(res, err);
                                })    
                            })
                        }
                    });
                    
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
	}
];