const Payment = require("../models/PaymentModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);


// Book Schema
function PaymentData(data) {
	this.id = data._id;
	this.user = data.user;
    this.userLoan = data.userLoan;
    this.paymentType = data.paymentType,
    this.paymentId = data.paymentId,
    this.amount = data.amount,
    this.status = data.status
}

/**
 * Book List.
 * 
 * @returns {Object}
 */


 exports.paymentList = [
	auth,
	function (req, res) {
		try {
			Payment.find({},"_id user userLoan paymentType paymentId amount status createdAt").populate([
                {
                  path: "user",
                  model: "User",

                },
                {
                    path: "userLoan",
                    model: "UserLoan",
  
                }]).then((payments)=>{
				if(payments.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", payments);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

 exports.paymentUserList = [
	auth,
	function (req, res) {
        console.log('Req information #####################################')

        console.log(req.user)

        console.log('Req information #####################################')
		try {
			Payment.find({user : mongoose. Types. ObjectId(req.user._id)},"_id user userLoan paymentType paymentId amount status createdAt").populate([
                {
                  path: "user",
                  model: "User",

                },
                {
                    path: "userLoan",
                    model: "UserLoan",
  
                }]).then((payments)=>{
				if(payments.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", payments);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.paymentSpecificUserList = [
	auth,
	function (req, res) {
		try {
			Payment.find({user : mongoose. Types. ObjectId(req.params.id)},"_id user userLoan paymentType paymentId amount status createdAt").populate([
                {
                  path: "user",
                  model: "User",

                },
                {
                    path: "userLoan",
                    model: "UserLoan",
  
                }]).then((payments)=>{
				if(payments.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", payments);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];



/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.paymentDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operations success", {});
		}
		try {
			Payment.findOne({_id: req.params.id},"_id user userLoan paymentType paymentId amount status createdAt").populate([
                {
                  path: "user",
                  model: "User",

                },
                {
                    path: "userLoan",
                    model: "UserLoan",
  
                }]).then((payment)=>{                
				if(payment !== null){
					let paymentData = new PaymentData(payment);
					return apiResponse.successResponseWithData(res, "Operations success", paymentData);
				}else{
					return apiResponse.successResponseWithData(res, "Operations success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.paymentStore = [
	auth,
	body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
		.isMongoId().withMessage("User id is invalid."),
    body("userLoan").isLength({ min: 1 }).trim().withMessage("User loan id must be specified.")
		.isMongoId().withMessage("User loan id is invalid."),
    body("paymentType").isLength({ min: 1 }).trim().withMessage("Payment type must be specified.")
		.isLength({min : 1}).withMessage("Payment type at least 2 character long."),
    body("paymentId").isLength({ min: 1 }).trim().withMessage("Payment id must be specified.")
		.isLength({min : 1}).withMessage("Payment id at least 2 character long."),
    body("amount").isLength({ min: 1 }).trim().withMessage("Amount must be specified.")
		.isNumeric().withMessage("Amount should be numeric value."),
    body("status").isLength({ min: 1 }).trim().withMessage("Status must be specified.")
		.isLength({ min : 2}).withMessage("Status at least 2 character long."),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {

					// Create User object with escaped and trimmed data
					var payment = new Payment(
						{
                            user : req.body.user,
                            userLoan : req.body.userLoan,
                            paymentType : req.body.paymentType,
                            paymentId : req.body.paymentId,
                            amount :  req.body.amount,
                            status : req.body.status
						}
					);
						// Save user.
						payment.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
					        Payment.find({_id : payment._id}).populate([
                                {
                                  path: "user",
                                  model: "User",
                
                                },
                                {
                                    path: "userLoan",
                                    model: "UserLoan",
                  
                                }]
                                ).then((data) => {
                                return apiResponse.successResponseWithData(res,"Payment Created.", data);
                            }).catch((err) => {
                                return apiResponse.ErrorResponse(res, err);
                            })
							
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book update.
 * 
 * @param {string}      title 
 * @param {string}      description
 * @param {string}      isbn
 * 
 * @returns {Object}
 */
exports.paymentUpdate = [
	auth,
	body("user").isLength({ min: 1 }).trim().withMessage("User id must be specified.")
		.isMongoId().withMessage("User id is invalid."),
    body("userLoan").isLength({ min: 1 }).trim().withMessage("User loan id must be specified.")
		.isMongoId().withMessage("User loan id is invalid."),
    body("paymentType").isLength({ min: 1 }).trim().withMessage("Payment type must be specified.")
		.isLength({min : 1}).withMessage("Payment type at least 2 character long."),
    body("paymentId").isLength({ min: 1 }).trim().withMessage("Payment id must be specified.")
		.isLength({min : 1}).withMessage("Payment id at least 2 character long."),
    body("amount").isLength({ min: 1 }).trim().withMessage("Amount must be specified.")
		.isNumeric().withMessage("Amount should be numeric value."),
    body("status").isLength({ min: 1 }).trim().withMessage("Status must be specified.")
		.isLength({ min : 2}).withMessage("Status at least 2 character long."),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					Payment.findById(req.params.id, function (err, foundNotify) {
						if(foundNotify === null){
							return apiResponse.notFoundResponse(res,"Payment not exists with this id");
						}else{

							var payment = new Payment(
                                {
                                    _id : req.params.id,
                                    user : req.body.user,
                                    userLoan : req.body.userLoan,
                                    paymentType : req.body.paymentType,
                                    paymentId : req.body.paymentId,
                                    amount :  req.body.amount,
                                    status : req.body.status
                                }
                            );
								Payment.findByIdAndUpdate(req.params.id, payment, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{

                                        Payment.findById(req.params.id).populate([
                                            {
                                              path: "user",
                                              model: "User",
                            
                                            },
                                            {
                                                path: "userLoan",
                                                model: "UserLoan",
                              
                                            }]).then((data) => {
                                            return apiResponse.successResponseWithData(res,"Notification update Success.", data);
                                        })
										// let notifyData = new NotifyData(notify);
										// return apiResponse.successResponseWithData(res,"Notification update Success.", notifyData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Delete.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.paymentDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			Payment.findById(req.params.id, function (err, foundPayment) {
				if(foundPayment === null){
					return apiResponse.notFoundResponse(res,"Payment not exists with this id");
				}else{
						//delete book.
						Payment.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Payment delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];