const OfferBanner = require("../models/OfferBannerModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
// const uploadFile = require("../middlewares/upload");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");
const multer = require('multer');
const path = require('path');


exports.offerBannerList = [
	auth,
	function (req, res) {
		try {
			OfferBanner.find({},"_id loan image imageUrl offerPath createdAt").populate([
				{
					path : "loan",
					model : "Loan"
				}
			]).then((offerBanner)=>{
				if(offerBanner.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", offerBanner);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.offerBannerDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			OfferBanner.findOne({_id: req.params.id},"_id loan image imageUrl offerPath createdAt").populate([
				{
					path : "loan",
					model : "Loan"
				}
			]).then((offerBanner)=>{                
				if(offerBanner !== null){
					let offerBannerData = new OfferBanner(offerBanner);
					return apiResponse.successResponseWithData(res, "Operation success", offerBannerData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

const storage = multer.diskStorage({
    destination: function(req, file, cb) {
        cb(null, 'uploads/');
    },

    // By default, multer removes file extensions so let's add them back
    filename: function(req, file, cb) {
		cb(null, Date.now() + '-' + file.originalname);
    }
});

exports.offerBannerStore = [
	auth,
	body("loan").isLength({ min : 1 }).trim().withMessage("Loan must be specified.").isMongoId().withMessage("Invalid database object ID"),
	(req, res) => {
        const errors = validationResult(req);
        if (!errors.isEmpty()) {
            return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
        }
		try{
			let data = req.body;
			let upload = multer({ storage: storage}).single('image');
			upload(req, res, function(err) {
				if (req.fileValidationError) {
					return apiResponse.validationErrorWithData(res, "Validation Error.", req.fileValidationError)
				}
				else if (!req.file) {
					return res.status(400).send({status : 0, message: "Please select an image to upload" , data : null});
				}
				else if (err instanceof multer.MulterError) {
					return res.status(500).send({status : 0,  message: `Could not upload the file: ${req.file.originalname}. ${err}` , data : null});
				}
				else if (err) {
					return apiResponse.ErrorResponse(res, err);
				}

				var baseUrl = req.protocol + "://" + req.headers.host;
                
				var banner = new OfferBanner(
					{
					   loan : data.loan,
					   image : req.file.filename,
					   imageUrl: baseUrl + `/uploads/` + req.file.filename,
                       offerPath : `/loan/offer/${data.loan}`
					}
				)


				banner.save(function(err){
					if(err) { return apiResponse.ErrorResponse(res, err);}
					// return apiResponse.successResponseWithData(res,"Address Created.", address);
					// let offerBanner = {
					// 	_id: banner._id,
					// 	image: banner.image,
					// 	imageUrl : banner.imageUrl,
                    //     offerPath : banner.offerPath
					// };

					OfferBanner.findOne({_id: banner._id},"_id loan image imageUrl offerPath createdAt").populate([
						{
							path : "loan",
							model : "Loan"
						}
					]).then((offerBanner)=>{                
						if(offerBanner !== null){
							let offerBannerData = new OfferBanner(offerBanner);
							return apiResponse.successResponseWithData(res, "Operation success", offerBannerData);
						}else{
							return apiResponse.successResponseWithData(res, "Operation success", {});
						}
					});

					// return apiResponse.successResponseWithData(res,"Offer Banner Created.", offerBanner);
				})
	
			});
		}
		catch(err){
			return apiResponse.ErrorResponse(res, err);
		}
		
	}
];


exports.offerBannerUpdate = [
	auth,
	body("loan").isLength({ min : 1 }).trim().withMessage("Loan must be specified.").isMongoId().withMessage("Invalid database object ID"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					OfferBanner.findById(req.params.id, function (err, foundBanner) {
						if(foundBanner === null){
							return apiResponse.notFoundResponse(res,"Loan not exists with this id");
						}else{

							let data = req.body;
							let upload = multer({ storage: storage}).single('image');
							upload(req, res, function(err) {
								if (req.fileValidationError) {
									return apiResponse.validationErrorWithData(res, "Validation Error.", req.fileValidationError)
								}
								else if (!req.file) {
									return res.status(400).send({ status : 0, message: "Please select an image to upload" ,data : null});
								}
								else if (err instanceof multer.MulterError) {
									return res.status(500).send({ status : 0, message: `Could not upload the file: ${req.file.originalname}. ${err}`, data : null });
								}
								else if (err) {
									return apiResponse.ErrorResponse(res, err);
								}
								var baseUrl = req.protocol + "://" + req.headers.host;
								
								var banner = new OfferBanner(
									{
									   _id:req.params.id,
									   loan : data.loan,
									   image : req.file.filename,
									   imageUrl: baseUrl + `/uploads/` + req.file.filename,
                                       offerPath : `/loan/offer/${data.loan}`
									}
								)

				
						   OfferBanner.findByIdAndUpdate(req.params.id, banner, {},function (err) {
								if (err) { 
									return apiResponse.ErrorResponse(res, err); 
								}else{
									OfferBanner.findById(req.params.id).populate("loan").then((data) => {
										return apiResponse.successResponseWithData(res,"Offer Banner update Success.", data);
									});
								}
							});
						  });
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.offerBannerDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			OfferBanner.findById(req.params.id, function (err, loan) {
				if(loan === null){
					return apiResponse.notFoundResponse(res,"Offer banner not exists with this id");
				}else{
					//delete book.
					OfferBanner.findByIdAndRemove(req.params.id,function (err) {
						if (err) { 
							return apiResponse.ErrorResponse(res, err); 
						}else{
							return apiResponse.successResponse(res,"Offer banner delete Success.");
						}
					});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.offerBannerBulkDelete = [
	auth,
	function (req, res) {
        if(!Array.isArray(req.body.offer_banners)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.offer_banners.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.offer_banners[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid object ID");
            } 
        }
		try {
            OfferBanner.deleteMany({ _id : {$in : req.body.offer_banners}}).then(result => {
				console.log(result)
                return apiResponse.successResponse(res,"Offer banner delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];