const Loan = require("../models/LoanModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");

// Book Schema
function LoanData(data) {
	this._id = data._id;
	this.loanType= data.loanType;
	this.name = data.name;
    this.minAmount = data.minAmount;
	this.maxAmount = data.maxAmount;
	// this.monthDuration = data.monthDuration;
	// this.yearDuration = data.yearDuration;
	// this.interest = data.interest;
	this.description = data.description;
	this.durationWithInterest = data.durationWithInterest;
}

/**
 * Book List.
 * 
 * @returns {Object}
 */
exports.loanList = [
	auth,
	function (req, res) {
		try {
			Loan.find({},"_id loanType name minAmount maxAmount durationWithInterest description createdAt").populate("loanType").then((loan)=>{
				if(loan.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", loan);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.loanDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			Loan.findOne({_id: req.params.id},"_id loanType name minAmount maxAmount durationWithInterest description createdAt").populate("loanType").then((loan)=>{                
				if(loan !== null){
					let loanData = new Loan(loan);
					return apiResponse.successResponseWithData(res, "Operation success", loanData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.loanTypeList = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Validation Error.", null);
		}
		try {
			Loan.find({loanType: req.params.id},"_id loanType name minAmount maxAmount durationWithInterest description createdAt").populate("loanType").then((loans)=>{                
				if(loans !== null || loans.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", loans);
				}else{
					return apiResponse.successResponseWithData(res, "No loan found", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.loanStore = [
	auth,
	body("loanType").isLength({ min : 1 }).trim().withMessage("Loan Type must be specified.").isMongoId().withMessage("Invalid database object ID"),
	body("name").isLength({ min : 1 }).trim().withMessage("Loan name must be specified.").isLength({min : 2}).withMessage("Loan name aat least 2 character long"),
	body("minAmount").isLength({ min : 1 }).trim().withMessage("Minimum amount must be specified.").isNumeric().withMessage("Minimum number should be numeric"),
	body("maxAmount").isLength({ min : 1 }).trim().withMessage("Maximum amount must be specified.").isNumeric().withMessage("Maximum number should be numeric"),
	// body("monthDuration").isLength({ min : 1 }).trim().withMessage("Month duration must be specified.").isNumeric().withMessage("Month duration should be numeric"),
	// body("yearDuration").isLength({ min : 1 }).trim().withMessage("Year duration must be specified.").isNumeric().withMessage("Year duration should be numeric"),
	// body("interest").isLength({ min: 1 }).trim().withMessage("Interest must be specified.")
	// 	.isNumeric().withMessage("Interest should be numeric"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
					var loan = new Loan(
						{
							loanType : req.body.loanType,
							name : req.body.name,
							minAmount : req.body.minAmount,
							maxAmount : req.body.maxAmount,
							// monthDuration : req.body.monthDuration,
							// yearDuration : req.body.yearDuration,
							// interest : req.body.interest,
							description : req.body.description,
							durationWithInterest : req.body.durationWithInterest,
						}
					);
						// Save user.
						loan.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							// let loanData = {
							// 	_id: loan._id,
							// 	loanType :  loan.loanType,
							// 	minAmount : loan.minAmount,
							// 	maxAmount : loan.maxAmount,
							// 	monthDuration : loan.monthDuration,
							// 	yearDuration : loan.yearDuration,
							// 	interest : loan.interest
							// };

							Loan.findById(loan._id).populate('loanType').then((loan) => {
								console.log('Populate')
								return apiResponse.successResponseWithData(res,"Loan Created.", loan);
							})
							// return apiResponse.successResponseWithData(res,"Loan Created.", loanData);
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book update.
 * 
 * @param {string}      title 
 * @param {string}      description
 * @param {string}      isbn
 * 
 * @returns {Object}
 */
exports.loanUpdate = [
	auth,
	body("loanType").isLength({ min : 1 }).trim().withMessage("Loan Type must be specified.").isMongoId().withMessage("Invalid database object ID"),
	body("name").isLength({ min : 1 }).trim().withMessage("Loan name must be specified.").isLength({min : 2}).withMessage("Loan name at least 2 character long"),
	body("minAmount").isLength({ min : 1 }).trim().withMessage("Minimum amount must be specified.").isNumeric().withMessage("Minimum number should be numeric"),
	body("maxAmount").isLength({ min : 1 }).trim().withMessage("Maximum amount must be specified.").isNumeric().withMessage("Maximum number should be numeric"),
	// body("monthDuration").isLength({ min : 1 }).trim().withMessage("Month duration must be specified.").isNumeric().withMessage("Month duration should be numeric"),
	// body("yearDuration").isLength({ min : 1 }).trim().withMessage("Year duration must be specified.").isNumeric().withMessage("Year duration should be numeric"),
	// body("interest").isLength({ min: 1 }).trim().withMessage("Interest must be specified.")
	// 	.isNumeric().withMessage("Interest should be numeric"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			console.log(errors)
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					Loan.findById(req.params.id, function (err, foundLoan) {
						if(foundLoan === null){
							return apiResponse.notFoundResponse(res,"Loan not exists with this id");
						}else{

							var loan = new Loan(
								{
									loanType : req.body.loanType,
									name : req.body.name,
									minAmount : req.body.minAmount,
									maxAmount : req.body.maxAmount,
									// monthDuration : req.body.monthDuration,
									// yearDuration : req.body.yearDuration,
									// interest : req.body.interest,
									description : req.body.description,
									durationWithInterest :req.body.durationWithInterest,
									_id:req.params.id
								}
							);
				
                            Loan.findByIdAndUpdate(req.params.id, loan, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{
										Loan.findById(req.params.id).populate("loanType").then((data) => {
											return apiResponse.successResponseWithData(res,"Loan update Success.", data);
										})
										// let loanData = new LoanData(loan);
										// return apiResponse.successResponseWithData(res,"Loan update Success.", loanData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Delete.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.loanDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			Loan.findById(req.params.id, function (err, loan) {
				if(loan === null){
					return apiResponse.notFoundResponse(res,"Loan not exists with this id");
				}else{
						//delete book.
						Loan.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Loan delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.loanBulkDelete = [
	auth,
	function (req, res) {
        if(!Array.isArray(req.body.loans)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.loans.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.loans[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }

		try {
            Loan.deleteMany({ _id : {$in : req.body.loans}}).then(result => {
                return apiResponse.successResponse(res,"User Loan delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];