const LoanBanner = require("../models/LoanBannerModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
// const uploadFile = require("../middlewares/upload");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");
const multer = require('multer');
const path = require('path');


exports.loanBannerList = [
	auth,
	function (req, res) {
		try {
			LoanBanner.find({},"_id loanType image imageUrl createdAt").populate([
				{
					path : "loanType",
					model : "LoanType"
				}
			]).then((loanBanner)=>{
				if(loanBanner.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", loanBanner);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.loanBannerDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			LoanBanner.findOne({_id: req.params.id},"_id loanType image imageUrl createdAt").populate([
				{
					path : "loanType",
					model : "LoanType"
				}
			]).then((loanBanner)=>{                
				if(loanBanner !== null){
					let loanBannerData = new Loan(loanBanner);
					return apiResponse.successResponseWithData(res, "Operation success", loanBannerData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

const storage = multer.diskStorage({
    destination: function(req, file, cb) {
        cb(null, 'uploads/');
    },

    // By default, multer removes file extensions so let's add them back
    filename: function(req, file, cb) {
		cb(null, Date.now() + '-' + file.originalname);
    }
});

exports.loanBannerStore = [
	auth,
	body("loanType").isLength({ min : 1 }).trim().withMessage("Loan Type must be specified.").isMongoId().withMessage("Invalid database object ID"),
	(req, res) => {
		try{
			let data = req.body;
			let upload = multer({ storage: storage}).single('image');
			upload(req, res, function(err) {
				if (req.fileValidationError) {
					return apiResponse.validationErrorWithData(res, "Validation Error.", req.fileValidationError)
				}
				else if (!req.file) {
					return res.status(400).send({ message: "Please select an image to upload" });
				}
				else if (err instanceof multer.MulterError) {
					return res.status(500).send({ message: `Could not upload the file: ${req.file.originalname}. ${err}` });
				}
				else if (err) {
					return res.send(err);
				}

				var baseUrl = req.protocol + "://" + req.headers.host;
				var banner = new LoanBanner(
					{
					   loanType : data.loanType,
					   image : req.file.filename,
					   imageUrl: baseUrl + `/uploads/` + req.file.filename
					}
				)

				banner.save(function(err){
					if(err) { return apiResponse.ErrorResponse(res, err);}
					// return apiResponse.successResponseWithData(res,"Address Created.", address);
					let loanBanner = {
						_id: banner._id,
						image: banner.image,
						imageUrl : banner.imageUrl
					};
					return apiResponse.successResponseWithData(res,"Loan Type Created.", loanBanner);
				})
	
				// res.status(200).send({message: "Banner added successfully. "});
				// console.log(req.file)
		
				
				// res.send(`You have uploaded this image: <hr/><img src="${req.file.path}" width="500"><hr /><a href="./">Upload another image</a>`);
			});
		}
		catch(err){
			return apiResponse.ErrorResponse(res, err);
		}
		
	}
];


exports.loanBannerUpdate = [
	auth,
	body("loanType").isLength({ min : 1 }).trim().withMessage("Loan Type must be specified.").isMongoId().withMessage("Invalid database object ID"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					LoanBanner.findById(req.params.id, function (err, foundBanner) {
						if(foundBanner === null){
							return apiResponse.notFoundResponse(res,"Loan not exists with this id");
						}else{

							let data = req.body;
							let upload = multer({ storage: storage}).single('image');
							upload(req, res, function(err) {
								if (req.fileValidationError) {
									return apiResponse.validationErrorWithData(res, "Validation Error.", req.fileValidationError)
								}
								else if (!req.file) {
									return res.status(400).send({ status : 0, message: "Please select an image to upload" ,data : null});
								}
								else if (err instanceof multer.MulterError) {
									return res.status(500).send({ status : 0, message: `Could not upload the file: ${req.file.originalname}. ${err}`, data : null });
								}
								else if (err) {
									return apiResponse.ErrorResponse(res, err);
								}

								var baseUrl = req.protocol + "://" + req.headers.host;
								
								var banner = new LoanBanner(
									{
									   _id:req.params.id,
									   loanType : data.loanType,
									   image : req.file.filename,
									   imageUrl: baseUrl + `/uploads/` + req.file.filename
									}
								)

				
							LoanBanner.findByIdAndUpdate(req.params.id, banner, {},function (err) {
								if (err) { 
									return apiResponse.ErrorResponse(res, err); 
								}else{
									LoanBanner.findById(req.params.id).populate("loanType").then((data) => {
										return apiResponse.successResponseWithData(res,"Loan Banner update Success.", data);
									});
								}
							});
						  });
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.loanBannerDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			LoanBanner.findById(req.params.id, function (err, loan) {
				if(loan === null){
					return apiResponse.notFoundResponse(res,"Loan banner not exists with this id");
				}else{
					//delete book.
					LoanBanner.findByIdAndRemove(req.params.id,function (err) {
						if (err) { 
							return apiResponse.ErrorResponse(res, err); 
						}else{
							return apiResponse.successResponse(res,"Loan banner delete Success.");
						}
					});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.loanBannerBulkDelete = [
	auth,
	function (req, res) {
		console.log(req.body.loan_banners)
        if(!Array.isArray(req.body.loan_banners)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.loan_banners.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.loan_banners[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid object ID");
            } 
        }
		try {
            LoanBanner.deleteMany({ _id : {$in : req.body.loan_banners}}).then(result => {
                return apiResponse.successResponse(res,"Loan banner delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];