const JobType = require("../models/JobTypeModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const utility = require("../helpers/utility");
const jwt = require('express-jwt')

// Book Schema
function JobTypeData(data) {
	this.id = data._id;
	this.name= data.name;
}

/**
 * Book List.
 * 
 * @returns {Object}
 */
exports.jobTypeList = [
	auth,
	function (req, res) {
		try {
			console.log(req.user._id)

			JobType.find({},"_id name createdAt").then((jobTypes)=>{
				if(jobTypes.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", jobTypes);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.jobTypeDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			JobType.findOne({_id: req.params.id},"_id name createdAt").then((jobType)=>{                
				if(jobType !== null){
					let jobTypeData = new JobTypeData(jobType);
					return apiResponse.successResponseWithData(res, "Operation success", jobTypeData);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.jobTypeStore = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must me minimum 2 characters long."),
	sanitizeBody("name").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {

					// Create User object with escaped and trimmed data
					var jobType = new JobType(
						{
							name: req.body.name,
						}
					);
						// Save user.
						jobType.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							let jobTypeData = {
								_id: jobType._id,
								name: jobType.name,
							};
							return apiResponse.successResponseWithData(res,"Job Type Created.", jobTypeData);
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book update.
 * 
 * @param {string}      title 
 * @param {string}      description
 * @param {string}      isbn
 * 
 * @returns {Object}
 */
exports.jobTypeUpdate = [
	auth,
	body("name").isLength({ min: 1 }).trim().withMessage("Name must be specified.")
		.isLength({min : 2}).withMessage("Name must be at least 2 characters long."),
	sanitizeBody("name").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					JobType.findById(req.params.id, function (err, foundJobType) {
						if(foundJobType === null){
							return apiResponse.notFoundResponse(res,"Job Type not exists with this id");
						}else{

							var jobType = new JobType(
								{
									name: req.body.name,
									_id:req.params.id
								}
							);
				
                            JobType.findByIdAndUpdate(req.params.id, jobType, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{
										let jobTypeData = new JobTypeData(jobType);
										return apiResponse.successResponseWithData(res,"Job Type update Success.", jobTypeData);
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Delete.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.jobTypeDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			JobType.findById(req.params.id, function (err, foundJobType) {
				if(foundJobType === null){
					return apiResponse.notFoundResponse(res,"Job Type not exists with this id");
				}else{
						//delete book.
						JobType.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"Job Type delete Success.");
							}
						});
				
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.jobTypeBulkDelete = [
	auth,
	function (req, res) {
        if(!Array.isArray(req.body.job_types)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.job_types.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.job_types[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }
		try {
            JobType.deleteMany({ _id : {$in : req.body.address_types}}).then(result => {
                return apiResponse.successResponse(res,"Job types delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];