/* eslint-disable no-dupe-keys */
const UserModel = require("../models/UserModel");
const { body,validationResult } = require("express-validator");
const { sanitizeBody } = require("express-validator");
//helper file to prepare responses.
const apiResponse = require("../helpers/apiResponse");
const utility = require("../helpers/utility");
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const mailer = require("../helpers/mailer");
const { constants } = require("../helpers/constants");
const { default: axios } = require("axios");

exports.register = [
	body("firstName").isLength({ min: 1 }).trim().withMessage("First name must be specified.")
		.isAlphanumeric().withMessage("First name has non-alphanumeric characters."),
	body("lastName").isLength({ min: 1 }).trim().withMessage("Last name must be specified.")
		.isAlphanumeric().withMessage("Last name has non-alphanumeric characters."),
	body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
		.isEmail().withMessage("Email must be a valid email address.").custom((value) => {
			return UserModel.findOne({email : value}).then((user) => {
				if (user) {
					return Promise.reject("E-mail already in use");
				}
			});
		}),
	body("mobileNumber").isLength({min : 1}).trim().withMessage("Mobile number is required").isNumeric().withMessage("Mobile number should be numeric").isMobilePhone().withMessage("Mobile number is invalid").custom((value) => {
		return UserModel.findOne({mobileNumber : value}).then((user) => {
			if (user) {
                return Promise.reject("Mobile number already in use");
			}
		});
	}),
	body("password").isLength({ min: 6 }).trim().withMessage("Password must be 6 characters or greater."),
	// Sanitize fields.
	sanitizeBody("firstName").escape(),
	sanitizeBody("lastName").escape(),
	sanitizeBody("email").escape(),
	sanitizeBody("password").escape(),
	// Process request after validation and sanitization.
	(req, res) => {
		try {
			// Extract the validation errors from a request.
			const errors = validationResult(req);
			// const useData = UserModel.findOne({email : req.body.email});
			if (!errors.isEmpty()) {
				// Display sanitized values/errors messages.
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				//hash input password
				UserModel.findOne({mobileNumber: req.body.mobileNumber}, function(err,user){
					if (err) return res.send(500, {error: err});

					bcrypt.hash(req.body.password,10,function(err, hash) {
						// generate OTP for confirmation
						 //let otp = utility.randomNumber(4);
						const otp = 1234;
						// const message = `hi, your otp for loanapp login is {otp}Welcome to 1lone.com. {#var#} is your Login OTP, Treat this as confidential. Please don't share this with anyone. Regards 1loneOTP Plutus Global`;
						// const values = {  
						// 	'usr' : "Globalplutus",
						// 	'key' : process.env.smsapikye || "44D2D25B-6A41-4CB5-A16D-FD3B505CBE73",
						// 	'to' : 9893578863,
						// 	'msg' : message,
						// 	'from' : "GLOPLT",
						// 	'rout' : 'Transactional',
						// 	'smstype' : 'TextSMS',
						// 	'templateid':''
		
						// }
						// const url = `http://www.smsbox.in/api/sms/SendSMS.aspx?usr=Globalplutus&key=18A87909-901D-40CD-A365-E86FE127F84D&smstype=TextSMS&to=6264883292&msg=Welcome to 1lone.com. is your Login OTP, Treat this as confidential. Please don't share this with anyone. Regards 1loneOTP Plutus Global&rout=Transactional&from=GLOPLT&templateid=1507166159904384041`;

						// // Send GET request to the API
						// axios.post(url)
						// 	.then(response => {
						// 		console.log("Response:", response.data); // Log the response data
						// 		// Check if the response indicates success (if applicable)
						// 		if (response.data && response.data.status === 'success') {
						// 			console.log("OTP sent successfully");
						// 			res.status(200).json({ success: true, message: "OTP sent successfully" });
						// 		} else {
						// 			console.error( error.message );
						// 			res.status(500).json({ success: false, error: "Failed to send OTP: Invalid response" });
						// 		}
						// 	})
						// 	.catch(error => {
						// 		console.error("Error sending OTP:", error); // Log the error
						// 		res.status(500).json({ success: false, error: "Failed to send OTP" });
						// 	});
								
						// return;
						var user = new UserModel(
							{
								firstName: req.body.firstName,
								lastName: req.body.lastName,
								email: req.body.email,
								mobileNumber : req.body.mobileNumber,
								isConfirmed : true,
								status : true,
								password: hash,
								confirmOTP: null
							}
						);
						// // Html email body
						// let html = "<p>Please Confirm your Account.</p><p>OTP: "+otp+"</p>";
						// // Send confirmation email
						// mailer.send(
						// 	constants.confirmEmails.from,
						// 	req.body.email,
						// 	"Confirm Account",
						// 	html
						// ).then(function(){
							// Save user.
							user.save(function (err) {
								if (err) { return apiResponse.ErrorResponse(res, err); }
								let userData = {
									_id: user._id,
									firstName: user.firstName,
									lastName: user.lastName,
									email: user.email,
									mobileNumber : user.mobileNumber,
									role : user.role,
									isConfirmed : user.isConfirmed,
									dob :user.dob,
									panCard : user.panCard,
									status : user.status
								};
								return apiResponse.successResponseWithData(res,"Registration Success.", userData);
							});
						// }).catch(err => {
						// 	return apiResponse.ErrorResponse(res,err);
						// }) ;
					});
				})
			}
		} catch (err) {
			//throw error in json response with status 500.
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.adminLogin = [
	body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
		.isEmail().withMessage("Email must be a valid email address."),
	body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified."),
	sanitizeBody("email").escape(),
	sanitizeBody("password").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}else {
				UserModel.findOne({email : req.body.email}).then(user => {
					if (user) {
						
						//Compare given password with db's hash.
						bcrypt.compare(req.body.password,user.password,function (err,same) {
							console.log('DSTS')
                            console.log(same)
							console.log('DSTS')
							if(same){
								console.log('Inside the same')
								//Check account confirmation.
								if(user.isConfirmed){
									// Check User's account active or not.
									
									if(user.role !== 'admin'){
										return apiResponse.unauthorizedResponse(res, "Your are not a administrator user");
									}
									else if(user.status) {
										// let user = UserModel.findById(user._id);
										let userData = {
											_id: user._id,
											firstName: user.firstName,
											lastName: user.lastName,
											email: user.email,
											role : user.role,
										};
										
										//Prepare JWT token for authentication
										const jwtPayload = userData;
										const jwtData = {
											expiresIn: process.env.JWT_TIMEOUT_DURATION,
										};
										const secret = process.env.JWT_SECRET;
										//Generated JWT token with Payload and secret.
										userData.token = jwt.sign(jwtPayload, secret, jwtData);
										return apiResponse.successResponseWithData(res,"Login Success.", userData);
									}
									else {
										return apiResponse.unauthorizedResponse(res, "Account is not active. Please contact admin.");
									}
								}else{
									return apiResponse.unauthorizedResponse(res, "Account is not confirmed. Please confirm your account.");
								}
							}else{
								return apiResponse.unauthorizedResponse(res, "Email or Password wrong.");
							}
						});
					}else{
						return apiResponse.unauthorizedResponse(res, "Email or Password wrong.");
					}
				});
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.login = [
	body("mobileNumber").isLength({min : 1}).trim().withMessage("Mobile number is required").isNumeric().withMessage("Mobile number should be numeric").isMobilePhone().withMessage("Mobile number is invalid"),
	// body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified."),
	sanitizeBody("mobileNumber").escape(),
	// sanitizeBody("password").escape(),
	async(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}else {
				//const otp =  Math.floor(1000 + Math.random() * 9000);
				const otp = 1234;
				const update = {'otp': otp};
				UserModel.findOne({mobileNumber: req.body.mobileNumber}, function(err,user){
					if (err) return res.send(500, {error: err});
	
					if ( user !== null) {
						//Compare given password with db's hash.
						// bcrypt.compare(req.body.password,user.password,function (err,same) {
						// 	if (err) return res.send(500, {error: err});
						// 	if(same){
								//Check account confirmation.
								if(user.isConfirmed){
									if(user.status) {
										axios.get(`http://www.smsbox.in/api/sms/SendSMS.aspx?usr=Globalplutus&key=18A87909-901D-40CD-A365-E86FE127F84D&smstype=TextSMS&to=91${req.body.mobileNumber}&msg=Welcome to 1lone.com. ${otp} is your Login OTP, Treat this as confidential. Please don't share this with anyone. Regards 1loneOTP Plutus Global&rout=Transactional&from=GLOPLT&templateid=1507166159904384041`)
										.then(result => {
											// console.log(result.data)
											// console.log('OTP INFO')
											// console.log(result.status)
											// console.log('OTP INFO')
											if(result.status === 200){
												const query = {mobileNumber : req.body.mobileNumber};
												UserModel.findOneAndUpdate(query, update, {upsert: true}, function(err, doc) {
												   if (err) 
													{
														return apiResponse.ErrorResponse(res, 'Internal server error.');
													}
													else{
														return apiResponse.successResponse(res,'OTP sent to your mobile number successfully.');
													}
											   });
											}
											else{
												return apiResponse.ErrorResponse(res,result.data.description);
											}
											
										})
										.catch(er => {
                                             res.send(500,{status : 0, message : 'Unable to send OTP', data : null})
										})
									}else {
										return apiResponse.validationErrorWithData(res, "Account is not active. Please contact admin.", []);
									}
								}else{
									return apiResponse.validationErrorWithData(res, "Account is not confirmed. Please confirm your account.", []);
								}
						// 	}else{
						// 		return apiResponse.unauthorizedResponse(res, "Mobile number or Password wrong.");
						// 	}
						// });
					}else{
						
						var data = new UserModel({
							firstName: null,
							lastName: null,
							email: null,
							mobileNumber : req.body.mobileNumber,
							isConfirmed : true,
							status : true,
							confirmOTP: null,
							otp : otp
						})

						data.save(function (err) {
							if (err) { return apiResponse.ErrorResponse(res, err); }
							// let userData = {
							// 	_id: user._id,
							// 	firstName: user.firstName,
							// 	lastName: user.lastName,
							// 	email: user.email,
							// 	mobileNumber : user.mobileNumber,
							// 	role : user.role,
							// 	isConfirmed : user.isConfirmed,
							// 	dob :user.dob,
							// 	panCard : user.panCard,
							// 	status : user.status
							// };
							return apiResponse.successResponse(res,'OTP sent to your mobile number successfully.');
						});
						// return apiResponse.unauthorizedResponse(res, "Mobile number not belongs to any user.");
					}
				})
				
				// UserModel.findOne({mobileNumber: req.body.mobileNumber}).then(user => {
				// 	console.log(user);
				// 	res.send('Here');
				// 	if (user) {
						
				// 		//Compare given password with db's hash.
				// 		bcrypt.compare(req.body.password,user.password,function (err,same) {
				// 			res.send(same);
				// 			// if(same){
				// 			// 	//Check account confirmation.
				// 			// 	if(user.isConfirmed){
				// 			// 		// Check User's account active or not.
				// 			// 		if(user.status) {
				// 			// 			// const otp =  Math.floor(100000 + Math.random() * 900000);
				// 			// 			const update = {'otp': 1234};
				// 			// 			const query = {mobileNumber : req.body.mobileNumber};
				// 			// 			// UserModel.findOneAndUpdate(query, update, {upsert: true}, function(err, doc) {

				// 			// 				res.send('Here')
				// 			// 				// if (err) return apiResponse.ErrorResponse(res, 'Internal server error.');
											
				// 			// 				// return apiResponse.successResponse(res,'OTP sent to your mobile number successfully.');
				// 			// 			// });
										
				// 			// 		}else {
				// 			// 			return apiResponse.validationErrorWithData(res, "Account is not active. Please contact admin.", []);
				// 			// 		}
				// 			// 	}else{
				// 			// 		return apiResponse.validationErrorWithData(res, "Account is not confirmed. Please confirm your account.", []);
				// 			// 	}
				// 			// }else{
				// 			// 	return apiResponse.unauthorizedResponse(res, "Mobile number or Password wrong.");
				// 			// }
				// 		});
				// 	}else{
				// 		return apiResponse.unauthorizedResponse(res, "Mobile number not belongs to any user.");
				// 	}
				// });
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.confirmOtp = [
	body("mobileNumber").isLength({ min: 1 }).trim().withMessage("Mobile number must be specified."),
	body("otp").isLength({ min: 1 }).trim().withMessage("Otp must be specified."),
	sanitizeBody("mobileNumber").escape(),
	sanitizeBody("otp").escape(),
	async (req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			} else {
				const user = await UserModel.findOne({ mobileNumber: req.body.mobileNumber, otp: req.body.otp });
				if (user) {
					console.log("OTP verified successfully!");
					const accessToken = jwt.sign({ userId: user._id }, process.env.JWT_SECRET || '123123');
					res.status(200).json({ accessToken, user });
				} else {
					console.log("Invalid OTP!");
					res.status(400).json({
						success: false,
						message: "Invalid OTP"
					});
				}
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

//for first and last name 

exports.savefist = [
	
    // Validate input fields
    body("firstname").isLength({ min: 1 }).withMessage("First name must be specified."),
    body("lastname").isLength({ min: 1 }).withMessage("Last name must be specified."),
    
    // Sanitize input fields
    body("firstname").trim().escape(),
    body("lastname").trim().escape(),

    async (req, res) => {
        // Check for validation errors
        const errors = validationResult(req);
        if (!errors.isEmpty()) {
            return res.status(400).json({ errors: errors.array() });
        }

        const userId = req.body.userid;
        const userdetails = {
			head: req.body.head,
            firstName: req.body.firstname,
            lastName: req.body.lastname,
			isConfirmed: true,
			status: true
        };
	console.log(req.body);
        try {
            // Update user details
           const resp = await UserModel.findByIdAndUpdate(userId, userdetails);
		   console.log(resp);
            console.log("User details updated successfully");
            return res.status(200).json("User details updated successfully");
        } catch (error) {
            console.error("Error updating user details:", error);
            return res.status(500).json({ error: "Internal Server Error" });
        }
    }
];

exports.savesecond = [

    // Validate input fields
//body("pancard").isLength({ min: 1 }).withMessage("Pan card must be specified."),
 //   body("dob").isISO8601().toDate().withMessage("Invalid date of birth format"),
   // body("pincode").isLength({ min: 1 }).withMessage("Pincode must be specified."),
    
    // Sanitize input fields
//	body("pancard").trim().escape(),
  //  body("dob").trim().escape(),
  //  body("pincode").trim().escape(),

   	 async (req, res) => {
        // Check for validation errors
		// const errors = validationResult(req);
        // if (!errors.isEmpty()) {
        //     return res.status(400).json({ errors: errors.array() });
        // }

        const userId = req.body.userid;
        const userdetails = {
            panCard: req.body.pancard,
            dob: req.body.dob,
            pincode: req.body.pincode,
			isConfirmed: true,
			status: true
        };
	console.log(req.body);
        try {
            // Update user details
            await UserModel.findByIdAndUpdate(userId, userdetails);
            console.log("User details updated successfully");
            return res.status(200).json("User details updated successfully");
        } catch (error) {
            console.error("Error updating user details:", error);
            return res.status(500).json({ error: "Internal Server Error" });
        }
    }
];

exports.savethird = [

    // Validate input fields
    body("email").isLength({ min: 1 }).withMessage("Email must be specified."),

    
    // Sanitize input fields
	body("email").trim().escape(),

   	 async (req, res) => {
        // Check for validation errors
		const errors = validationResult(req);
        if (!errors.isEmpty()) {
            return res.status(400).json({ errors: errors.array() });
        }

        const userId = req.body.userid;
        const userdetails = {
            email: req.body.email,
			isConfirmed: true,
			status: true
        };
	console.log(req.body);
        try {
            // Update user details
            await UserModel.findByIdAndUpdate(userId, userdetails);
            console.log("User details updated successfully");
            return res.status(200).json("User details updated successfully");
        } catch (error) {
            console.error("Error updating user details:", error);
            return res.status(500).json({ error: "Internal Server Error" });
        }
    }
];

exports.sendcreditotp = async (req, res) => {

	try {
      
        const userId = req.body.userId; 
        const user = await UserModel.findById(userId);
        if (!user) {
            return res.status(404).json({ success: false, message: "User not found" });
        }
        const phoneNumber = user.mobileNumber;

		console.log(phoneNumber);

        // Generate order ID using current time
        const orderId = new Date().getTime().toString();


        // API credentials and parameters
        const apiId = process.env.apiId || "AP100016";
        const token = process.env.token || "4fd3a394-fd8f-4dea-a044-f976c41daff2";
        const methodName = process.env.methodName || "creditreportEquifax";

        // Prepare post parameters
        const values = {
            apiid: apiId,
            token: token,
            methodName: methodName,
            orderid: orderId,
            phone_number: phoneNumber,
        };

        // API endpoint
        const url = "http://apimanage.websoftexpay.com/api/creditreport_generateOTP.aspx";

        // Function to send OTP
        const sendOTP = async () => {
            try {
                // Send OTP request to the API
                const response = await axios.post(url, values);
                console.log("OTP sent successfully:", response.data);

                // Respond with success message
                res.status(200).json({ success: true, message: "OTP sent successfully" });
            } catch (error) {
                console.error("Error sending OTP:", error.response.data);

                // Respond with error message
                res.status(500).json({ success: false, message: "Failed to send OTP" });
            }
        };

        // Call the function to send OTP
        sendOTP();
    } catch (error) {
        console.error("Error sending OTP:", error);

        // Respond with error message
        res.status(500).json({ success: false, message: "Internal server error" });
    }
};

exports.checkcredit =  async (req, res) => {
    try {

        const apiId = process.env.apiId || "AP100016";
        const token = process.env.token || "4fd3a394-fd8f-4dea-a044-f976c41daff2";
        const methodName = process.env.methodName || "creditreportEquifax";
        const { fname, lname, dob, phone_number, pan_num, otp } = req.body;

        // Prepare post parameters
        const requestData = {
            apiid: apiId,
            token: token,
            methodName: methodName,
            orderid: orderId,
            fname: fname,
            lname: lname,
            dob: dob,
            phone_number: phone_number,
            pan_num: pan_num,
            otp: otp
        };

        // API endpoint
        const apiUrl = "http://apimanage.websoftexpay.com/api/credit_report_euifax.aspx";

        // Send POST request to the API
        const response = await axios.post(apiUrl, requestData);

        console.log("API Response:", response.data);

        // Send the API response back to the client
        res.status(200).json(response.data);
    } catch (error) {
        console.error("Error:", error.response);
        // Send error response back to the client
        res.status(500).json({ error: error.message });
    }
};

exports.logins = [
	body("username").isLength({ min: 1 }).trim().withMessage("Username must be specified."),
	body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified."),
	sanitizeBody("email").escape(),
	sanitizeBody("password").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}else {
				UserModel.findOne({email: req.body.username}).then(user => {
					if (user) {
						//Compare given password with db's hash.
						bcrypt.compare(req.body.password,user.password,function (err,same) {
							if(same){
								//Check account confirmation.
								if(user.isConfirmed){
									// Check User's account active or not.
									if(user.status) {
										// let user = UserModel.findById(user._id);
										let userData = {
											_id: user._id,
											firstName: user.firstName,
											lastName: user.lastName,
											email: user.email,
											mobileNumber : user.mobileNumber,
											role : user.role,
											isConfirmed : user.isConfirmed,
											status : user.status
										};
										
										//Prepare JWT token for authentication
										const jwtPayload = userData;
										const jwtData = {
											expiresIn: process.env.JWT_TIMEOUT_DURATION,
										};
										const secret = process.env.JWT_SECRET;
										//Generated JWT token with Payload and secret.
										userData.token = jwt.sign(jwtPayload, secret, jwtData);
										return apiResponse.successResponseWithData(res,"Login Success.", userData);
									}else {
										return apiResponse.unauthorizedResponse(res, "Account is not active. Please contact admin.");
									}
								}else{
									return apiResponse.unauthorizedResponse(res, "Account is not confirmed. Please confirm your account.");
								}
							}else{
								return apiResponse.unauthorizedResponse(res, "Email or Password wrong.");
							}
						});
					}else{
						UserModel.findOne({mobileNumber: req.body.username}).then(user => {
							if (user) {
								//Compare given password with db's hash.
								bcrypt.compare(req.body.password,user.password,function (err,same) {
									if(same){
										//Check account confirmation.
										if(user.isConfirmed){
											// Check User's account active or not.
											if(user.status) {
												// let user = UserModel.findById(user._id);
												let userData = {
													_id: user._id,
													firstName: user.firstName,
													lastName: user.lastName,
													email: user.email,
													mobileNumber : user.mobileNumber,
													role : user.role,
													isConfirmed : user.isConfirmed,
													status : user.status
												};
												
												//Prepare JWT token for authentication
												const jwtPayload = userData;
												const jwtData = {
													expiresIn: process.env.JWT_TIMEOUT_DURATION,
												};
												const secret = process.env.JWT_SECRET;
												//Generated JWT token with Payload and secret.
												userData.token = jwt.sign(jwtPayload, secret, jwtData);
												return apiResponse.successResponseWithData(res,"Login Success.", userData);
											}else {
												return apiResponse.unauthorizedResponse(res, "Account is not active. Please contact admin.");
											}
										}else{
											return apiResponse.unauthorizedResponse(res, "Account is not confirmed. Please confirm your account.");
										}
									}else{
										return apiResponse.unauthorizedResponse(res, "Username or Password wrong.");
									}
								});
							}else{
								return apiResponse.unauthorizedResponse(res, "Username or Password wrong.");
							}
						});
					}
				});
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.verifyLoginConfirm = [

];

exports.verifyConfirm = [
	body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
		.isEmail().withMessage("Email must be a valid email address."),
	body("otp").isLength({ min: 1 }).trim().withMessage("OTP must be specified."),
	sanitizeBody("email").escape(),
	sanitizeBody("otp").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}else {
				var query = {email : req.body.email};
				UserModel.findOne(query).then(user => {
					if (user) {
						//Check already confirm or not.
						if(!user.isConfirmed){
							//Check account confirmation.
							if(user.confirmOTP == req.body.otp){
								//Update user as confirmed
								UserModel.findOneAndUpdate(query, {
									isConfirmed: 1,
									confirmOTP: null
								}).catch(err => {
									return apiResponse.ErrorResponse(res, err);
								});
								return apiResponse.successResponse(res,"Account confirmed success.");
							}else{
								return apiResponse.unauthorizedResponse(res, "Otp does not match");
							}
						}else{
							return apiResponse.unauthorizedResponse(res, "Account already confirmed.");
						}
					}else{
						return apiResponse.unauthorizedResponse(res, "Specified email not found.");
					}
				});
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.resendConfirmOtp = [
	body("email").isLength({ min: 1 }).trim().withMessage("Email must be specified.")
		.isEmail().withMessage("Email must be a valid email address."),
	sanitizeBody("email").escape(),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}else {
				var query = {email : req.body.email};
				UserModel.findOne(query).then(user => {
					if (user) {
						//Check already confirm or not.
						if(!user.isConfirmed){
							// Generate otp
							let otp = utility.randomNumber(4);
							// Html email body
							let html = "<p>Please Confirm your Account.</p><p>OTP: "+otp+"</p>";
							// Send confirmation email
							mailer.send(
								constants.confirmEmails.from,
								req.body.email,
								"Confirm Account",
								html
							).then(function(){
								user.isConfirmed = 0;
								user.confirmOTP = otp;
								// Save user.
								user.save(function (err) {
									if (err) { return apiResponse.ErrorResponse(res, err); }
									return apiResponse.successResponse(res,"Confirm otp sent.");
								});
							});
						}else{
							return apiResponse.unauthorizedResponse(res, "Account already confirmed.");
						}
					}else{
						return apiResponse.unauthorizedResponse(res, "Specified email not found.");
					}
				});
			}
		} catch (err) {
			return apiResponse.ErrorResponse(res, err);
		}
}];

exports.forgotPassword = [
	body("mobile").isLength({ min: 1 }).trim().withMessage("Mobile number must be specified.")
	.isNumeric().withMessage("Mobile number should be numeric."),
	sanitizeBody("mobile").escape(),
(req, res) => {
	try {
		const errors = validationResult(req);
		if (!errors.isEmpty()) {
			return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
		}else {
			UserModel.findOne({mobileNumber : req.body.mobile}).then(user => {
				if (user) {
					//Compare given password with db's hash.
					let otp = utility.randomNumber(4);
					let html = "<p>Your Forgot password </p><p>OTP: "+otp+"</p>";
					// Send confirmation email
					mailer.send(
						constants.confirmEmails.from,
						req.body.email,
						"Forgot Password",
						html
					).then(function(){
                       UserModel.findByIdAndUpdate(user._id,{resetOtp : otp},{}, function(err){
						return apiResponse.successResponseWithData(res,"Reset otp send successfully on email.");
					   })
					})
				}else{
					return apiResponse.unauthorizedResponse(res, "No user found related to this mobile number.");
				}
			});
		}
	} catch (err) {
		return apiResponse.ErrorResponse(res, err);
	}
}];

exports.resetPassword = [
	body("mobile").isLength({ min: 1 }).trim().withMessage("Mobile number must be specified.")
	.isNumeric().withMessage("Mobile number should be numeric."),
	body("otp").isLength({ min: 1 }).trim().withMessage("OTP must be specified.")
	.isLength({min : 4}).withMessage('OTP should be 4 digit long.')
	.isNumeric().withMessage("OTP should be numeric."),
	sanitizeBody("mobile").escape(),
(req, res) => {
	try {
		const errors = validationResult(req);
		if (!errors.isEmpty()) {
			return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
		}else {
			UserModel.findOne({mobileNumber : req.body.mobile, resetOtp : req.body.otp}).then(user => {
				if (user) {
					//Compare given password with db's hash.
					return apiResponse.successResponseWithData(res,"Change password",[]);
				}else{
					return apiResponse.unauthorizedResponse(res, "Invalid OTP");
				}
			});
		}
	} catch (err) {
		return apiResponse.ErrorResponse(res, err);
	}
}];

exports.changePassword = [
    body("mobile").isLength({ min: 1 }).trim().withMessage("Mobile number must be specified.")
	.isNumeric().withMessage("Mobile number should be numeric."),
	body("password").isLength({ min: 1 }).trim().withMessage("Password must be specified.")
	.isLength({min : 6}).withMessage("Password should be minimum 6 character long."),
	body("confirmPassword").isLength({ min: 1 }).trim().withMessage("Confirm password must be specified.")
	.isLength({min : 6}).withMessage("Confirm password should be minimum 6 character long."),
	sanitizeBody("mobile").escape(),
	sanitizeBody("password").escape(),
	sanitizeBody("confirmPassword").escape(),
(req, res) => {
	try {
		const errors = validationResult(req);
		if (!errors.isEmpty()) {
			return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
		} else if(req.body.password !== req.body.confirmPassword){
			return apiResponse.validationErrorWithData(res, "Confirm password should be equal to password", ['Confirm password should be equal to password']);
		}
		else {
			bcrypt.hash(req.body.password,10,function(err, hash){
				UserModel.findOne({mobileNumber : req.body.mobile}).then(user => {
					if (user) {
						//Compare given password with db's hash.
						let html = "<p>Your password changed successfully. </p>";
						// Send confirmation email
						mailer.send(
							constants.confirmEmails.from,
							user.email,
							"Changed Password",
							html
						).then(function(){
						   UserModel.findByIdAndUpdate(user._id,{password : hash, resetOtp : null},{}, function(err){
							return apiResponse.successResponseWithData(res,"Password chnaged successfully on email.",[]);
						   })
						})
					}else{
						return apiResponse.unauthorizedResponse(res, "No user found related to this mobile number.");
					}
				});
			})
			
		}
	} catch (err) {
		return apiResponse.ErrorResponse(res, err);
	}
}];
