const AppUpdate = require("../models/AppUpdateModel");
const { body,validationResult , check} = require("express-validator");
const { sanitizeBody } = require("express-validator");
const apiResponse = require("../helpers/apiResponse");
const auth = require("../middlewares/jwt");
var mongoose = require("mongoose");
mongoose.set("useFindAndModify", false);
const { constants } = require("../helpers/constants");
const bcrypt = require("bcrypt");
const utility = require("../helpers/utility");


// Book Schema
function AppUpdateDate(data) {
	this._id = data._id;
	this.version= data.version;
	this.releaseDate = data.releaseDate;
    this.key = data.key;
	this.createdAt = data.createdAt;
	this.updatedAt = data.updatedAt;
}

/**
 * Book List.
 * 
 * @returns {Object}
 */
exports.appUpdateList = [
	auth,
	function (req, res) {
		try {
			AppUpdate.find({}).then((update)=>{
				if(update.length > 0){
					return apiResponse.successResponseWithData(res, "Operation success", update);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", []);
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

/**
 * Book Detail.
 * 
 * @param {string}      id
 * 
 * @returns {Object}
 */
exports.appUpdateDetail = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.successResponseWithData(res, "Operation success", {});
		}
		try {
			AppUpdate.findOne({_id: req.params.id}).then((update)=>{                
				if(update !== null){
					return apiResponse.successResponseWithData(res, "Operation success", update);
				}else{
					return apiResponse.successResponseWithData(res, "Operation success", {});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.appUpdateStore = [
	auth,
	body("version").isLength({ min : 1 }).trim().withMessage("Version must be specified.").isNumeric().withMessage("Version should me numeric"),
	body("releaseDate").isLength({ min : 1 }).trim().withMessage("Release Date must be specified.").isDate().withMessage("Release Date is invalid"),
	check('key.*').isLength({ min : 3 }).withMessage("Key should be required and minimum 3 character long"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
					var appUpdate = new AppUpdate(
						{
							version : req.body.version,
							releaseDate : req.body.releaseDate,
							key : req.body.key,
						}
					);

						// Save user.
						appUpdate.save(function (err, update) {
                           
							if (err) { return apiResponse.ErrorResponse(res, err); }

							AppUpdate.findById(update._id).then((app) => {
								return apiResponse.successResponseWithData(res,"App update created.", app);
							})
						});

			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.appUpdateChange = [
	auth,
	body("version").isLength({ min : 1 }).trim().withMessage("Version must be specified.").isNumeric().withMessage("Version should me numeric"),
	body("releaseDate").isLength({ min : 1 }).trim().withMessage("Release Date must be specified.").isDate().withMessage("Release Date is invalid"),
	check('key.*').isLength({ min : 3 }).withMessage("Key should be required and minimum 3 character long"),
	(req, res) => {
		try {
			const errors = validationResult(req);
			if (!errors.isEmpty()) {
				return apiResponse.validationErrorWithData(res, "Validation Error.", errors.array());
			}
			else {
				if(!mongoose.Types.ObjectId.isValid(req.params.id)){
					return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
				}else{
					AppUpdate.findById(req.params.id, function (err, foundLoan) {
						if(foundLoan === null){
							return apiResponse.notFoundResponse(res,"App Update not exists with this id");
						}else{

							var appUpdate = new AppUpdate(
								{
									_id:req.params.id,
                                    version : req.body.version,
                                    releaseDate : req.body.releaseDate,
                                    key : req.body.key,
								}
							);

                          
				
                            AppUpdate.findByIdAndUpdate(req.params.id, appUpdate, {},function (err) {
									if (err) { 
										return apiResponse.ErrorResponse(res, err); 
									}else{
										AppUpdate.findById(req.params.id).then((data) => {
											return apiResponse.successResponseWithData(res,"App Update changed.", data);
										})
									}
								});
				
						}
					});
				}
			}
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];


exports.appUpdateDelete = [
	auth,
	function (req, res) {
		if(!mongoose.Types.ObjectId.isValid(req.params.id)){
			return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
		}
		try {
			AppUpdate.findById(req.params.id, function (err, loan) {
				if(loan === null){
					return apiResponse.notFoundResponse(res,"App Update not exists with this id");
				}else{
						//delete book.
						AppUpdate.findByIdAndRemove(req.params.id,function (err) {
							if (err) { 
								return apiResponse.ErrorResponse(res, err); 
							}else{
								return apiResponse.successResponse(res,"App Update delete Success.");
							}
						});
				}
			});
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];

exports.appUpdateBulkDelete = [
	auth,
	function (req, res) {
        if(!Array.isArray(req.body.appUpdates)){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
        } 
        
        for(var i= 0 ; i < req.body.appUpdates.length ; i++)
        {
            if(!mongoose.Types.ObjectId.isValid(req.body.appUpdates[i])){
            	return apiResponse.validationErrorWithData(res, "Invalid Error.", "Invalid ID");
            } 
        }

		try {
            AppUpdate.deleteMany({ _id : {$in : req.body.appUpdates}}).then(result => {
                return apiResponse.successResponse(res,"App Update delete Success.");
            })
            .catch(err => {
                return apiResponse.ErrorResponse(res, err);
            })
		} catch (err) {
			//throw error in json response with status 500. 
			return apiResponse.ErrorResponse(res, err);
		}
	}
];