const mongoose = require('mongoose');

// Define the user schema
const userSchema = new mongoose.Schema({
    role: {
        type: String,
        required: true
    },
    mob_number: {
        type: Number,
        required: true,
        unique: true
    },
    email: {
        type: String,
        unique: true
    }, 
    aadhar_num: {
        type: Number,
        unique: true
    },
    mobile_otp: { 
        type: String
    },
    access_token: {
        type: String
    },
    fullname: {
        type: String
    },
    license_num: {
        type: Number
    },
    upload_license: {
        type: String
    },
    upload_aadhar: {
        type: String
    },
    upload_profile: {
        type: String
    },
    language: {
        type: String
    }
}, { timestamps: true });


const UserModel = mongoose.model('User', userSchema);
module.exports = UserModel;


 