// homeController.js

const { Video, Chapter } = require('../model/homeModel');



// Controller function to fetch videos
const getVideos = async (req, res) => {
    try { 
        // Fetch all videos from the database
        const videos = await Video.find();
        res.status(200).json({ videos });
    } catch (error) {
        console.error("Error fetching videos:", error);
        res.status(500).send("Internal Server Error");
    }
};

// Controller function to fetch chapters
const getChapters = async (req, res) => {
    try {
        // Fetch all chapters from the database
        const chapters = await Chapter.find();
        res.status(200).json({ chapters });
    } catch (error) {
        console.error("Error fetching chapters:", error);
        res.status(500).send("Internal Server Error");
    }
};

module.exports = { getVideos, getChapters };

